/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.remoting.httpinvoker;

import java.lang.reflect.Method;
import java.net.ConnectException;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.springframework.aop.support.AopUtils;
import org.springframework.beans.factory.BeanClassLoaderAware;
import org.springframework.remoting.RemoteAccessException;
import org.springframework.remoting.RemoteConnectFailureException;
import org.springframework.remoting.httpinvoker.HttpInvokerClientConfiguration;
import org.springframework.remoting.httpinvoker.HttpInvokerRequestExecutor;
import org.springframework.remoting.httpinvoker.SimpleHttpInvokerRequestExecutor;
import org.springframework.remoting.support.RemoteInvocation;
import org.springframework.remoting.support.RemoteInvocationBasedAccessor;
import org.springframework.remoting.support.RemoteInvocationResult;

public class HttpInvokerClientInterceptor
extends RemoteInvocationBasedAccessor
implements MethodInterceptor,
HttpInvokerClientConfiguration,
BeanClassLoaderAware {
    private String codebaseUrl;
    private HttpInvokerRequestExecutor httpInvokerRequestExecutor;
    private ClassLoader beanClassLoader;

    public void setCodebaseUrl(String codebaseUrl) {
        this.codebaseUrl = codebaseUrl;
    }

    public String getCodebaseUrl() {
        return this.codebaseUrl;
    }

    public void setHttpInvokerRequestExecutor(HttpInvokerRequestExecutor httpInvokerRequestExecutor) {
        this.httpInvokerRequestExecutor = httpInvokerRequestExecutor;
    }

    public HttpInvokerRequestExecutor getHttpInvokerRequestExecutor() {
        return this.httpInvokerRequestExecutor;
    }

    public void setBeanClassLoader(ClassLoader classLoader) {
        this.beanClassLoader = classLoader;
    }

    public void afterPropertiesSet() {
        super.afterPropertiesSet();
        if (this.httpInvokerRequestExecutor == null) {
            SimpleHttpInvokerRequestExecutor executor = new SimpleHttpInvokerRequestExecutor();
            executor.setBeanClassLoader(this.beanClassLoader);
            this.httpInvokerRequestExecutor = executor;
        }
    }

    public Object invoke(MethodInvocation methodInvocation) throws Throwable {
        if (AopUtils.isToStringMethod((Method)methodInvocation.getMethod())) {
            return "HTTP invoker proxy for service URL [" + this.getServiceUrl() + "]";
        }
        RemoteInvocation invocation = this.createRemoteInvocation(methodInvocation);
        RemoteInvocationResult result = null;
        try {
            result = this.executeRequest(invocation);
        }
        catch (Throwable ex) {
            throw this.convertHttpInvokerAccessException(ex);
        }
        return this.recreateRemoteInvocationResult(result);
    }

    protected RemoteInvocationResult executeRequest(RemoteInvocation invocation) throws Exception {
        return this.getHttpInvokerRequestExecutor().executeRequest(this, invocation);
    }

    protected RemoteAccessException convertHttpInvokerAccessException(Throwable ex) {
        if (ex instanceof ConnectException) {
            throw new RemoteConnectFailureException("Cannot connect to HTTP invoker remote service at [" + this.getServiceUrl() + "]", ex);
        }
        if (ex instanceof ClassNotFoundException) {
            throw new RemoteAccessException("Cannot deserialize result from HTTP invoker remote service [" + this.getServiceUrl() + "]", ex);
        }
        throw new RemoteAccessException("Cannot access HTTP invoker remote service at [" + this.getServiceUrl() + "]", ex);
    }
}

