/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.bind.annotation.support;

import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import org.springframework.core.BridgeMethodResolver;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.util.ClassUtils;
import org.springframework.util.ReflectionUtils;
import org.springframework.web.bind.annotation.InitBinder;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.SessionAttributes;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HandlerMethodResolver {
    private final Set<Method> handlerMethods = new LinkedHashSet<Method>();
    private final Set<Method> initBinderMethods = new LinkedHashSet<Method>();
    private final Set<Method> modelAttributeMethods = new LinkedHashSet<Method>();
    private RequestMapping typeLevelMapping;
    private boolean sessionAttributesFound;
    private final Set<String> sessionAttributeNames = new HashSet<String>();
    private final Set<Class> sessionAttributeTypes = new HashSet<Class>();
    private final Set<String> actualSessionAttributeNames = Collections.synchronizedSet(new HashSet(4));

    public void init(final Class<?> handlerType) {
        LinkedHashSet handlerTypes = new LinkedHashSet();
        handlerTypes.add(handlerType);
        handlerTypes.addAll((Collection)Arrays.asList(handlerType.getInterfaces()));
        for (Class clazz : handlerTypes) {
            ReflectionUtils.doWithMethods((Class)clazz, (ReflectionUtils.MethodCallback)new ReflectionUtils.MethodCallback(){

                public void doWith(Method method) {
                    Method specificMethod = ClassUtils.getMostSpecificMethod((Method)method, (Class)handlerType);
                    Method bridgedMethod = BridgeMethodResolver.findBridgedMethod((Method)specificMethod);
                    if (HandlerMethodResolver.this.isHandlerMethod(specificMethod) && (bridgedMethod == specificMethod || !HandlerMethodResolver.this.isHandlerMethod(bridgedMethod))) {
                        HandlerMethodResolver.this.handlerMethods.add(specificMethod);
                    } else if (method.isAnnotationPresent(InitBinder.class)) {
                        HandlerMethodResolver.this.initBinderMethods.add(specificMethod);
                    } else if (method.isAnnotationPresent(ModelAttribute.class)) {
                        HandlerMethodResolver.this.modelAttributeMethods.add(specificMethod);
                    }
                }
            }, (ReflectionUtils.MethodFilter)ReflectionUtils.USER_DECLARED_METHODS);
        }
        this.typeLevelMapping = (RequestMapping)AnnotationUtils.findAnnotation(handlerType, RequestMapping.class);
        SessionAttributes sessionAttributes = (SessionAttributes)AnnotationUtils.findAnnotation(handlerType, SessionAttributes.class);
        boolean bl = this.sessionAttributesFound = sessionAttributes != null;
        if (this.sessionAttributesFound) {
            this.sessionAttributeNames.addAll((Collection<String>)Arrays.asList(sessionAttributes.value()));
            this.sessionAttributeTypes.addAll((Collection<Class>)Arrays.asList(sessionAttributes.types()));
        }
    }

    protected boolean isHandlerMethod(Method method) {
        return AnnotationUtils.findAnnotation((Method)method, RequestMapping.class) != null;
    }

    public final boolean hasHandlerMethods() {
        return !this.handlerMethods.isEmpty();
    }

    public final Set<Method> getHandlerMethods() {
        return this.handlerMethods;
    }

    public final Set<Method> getInitBinderMethods() {
        return this.initBinderMethods;
    }

    public final Set<Method> getModelAttributeMethods() {
        return this.modelAttributeMethods;
    }

    public boolean hasTypeLevelMapping() {
        return this.typeLevelMapping != null;
    }

    public RequestMapping getTypeLevelMapping() {
        return this.typeLevelMapping;
    }

    public boolean hasSessionAttributes() {
        return this.sessionAttributesFound;
    }

    public boolean isSessionAttribute(String attrName, Class attrType) {
        if (this.sessionAttributeNames.contains(attrName) || this.sessionAttributeTypes.contains(attrType)) {
            this.actualSessionAttributeNames.add(attrName);
            return true;
        }
        return false;
    }

    public Set<String> getActualSessionAttributeNames() {
        return this.actualSessionAttributeNames;
    }
}

