/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.util;

import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.springframework.util.Assert;
import org.springframework.util.MultiValueMap;

public abstract class UriComponents
implements Serializable {
    private static final String DEFAULT_ENCODING = "UTF-8";
    private static final Pattern NAMES_PATTERN = Pattern.compile("\\{([^/]+?)\\}");
    private final String scheme;
    private final String fragment;

    protected UriComponents(String scheme, String fragment) {
        this.scheme = scheme;
        this.fragment = fragment;
    }

    public final String getScheme() {
        return this.scheme;
    }

    public abstract String getSchemeSpecificPart();

    public abstract String getUserInfo();

    public abstract String getHost();

    public abstract int getPort();

    public abstract String getPath();

    public abstract List<String> getPathSegments();

    public abstract String getQuery();

    public abstract MultiValueMap<String, String> getQueryParams();

    public final String getFragment() {
        return this.fragment;
    }

    public final UriComponents encode() {
        try {
            return this.encode(DEFAULT_ENCODING);
        }
        catch (UnsupportedEncodingException e) {
            throw new InternalError("\"UTF-8\" not supported");
        }
    }

    public abstract UriComponents encode(String var1) throws UnsupportedEncodingException;

    public final UriComponents expand(Map<String, ?> uriVariables) {
        Assert.notNull(uriVariables, (String)"'uriVariables' must not be null");
        return this.expandInternal(new MapTemplateVariables(uriVariables));
    }

    public final UriComponents expand(Object ... uriVariableValues) {
        Assert.notNull((Object)uriVariableValues, (String)"'uriVariableValues' must not be null");
        return this.expandInternal(new VarArgsTemplateVariables(uriVariableValues));
    }

    public final UriComponents expand(UriTemplateVariables uriTemplateVars) {
        Assert.notNull((Object)uriTemplateVars, (String)"'uriTemplateVars' must not be null");
        return this.expandInternal(uriTemplateVars);
    }

    abstract UriComponents expandInternal(UriTemplateVariables var1);

    public abstract UriComponents normalize();

    public abstract String toUriString();

    public abstract URI toUri();

    public final String toString() {
        return this.toUriString();
    }

    static String expandUriComponent(String source, UriTemplateVariables uriVariables) {
        if (source == null) {
            return null;
        }
        if (source.indexOf(123) == -1) {
            return source;
        }
        Matcher matcher = NAMES_PATTERN.matcher(source);
        StringBuffer sb = new StringBuffer();
        while (matcher.find()) {
            String match = matcher.group(1);
            String variableName = UriComponents.getVariableName(match);
            Object variableValue = uriVariables.getValue(variableName);
            String variableValueString = UriComponents.getVariableValueAsString(variableValue);
            String replacement = Matcher.quoteReplacement(variableValueString);
            matcher.appendReplacement(sb, replacement);
        }
        matcher.appendTail(sb);
        return sb.toString();
    }

    private static String getVariableName(String match) {
        int colonIdx = match.indexOf(58);
        return colonIdx != -1 ? match.substring(0, colonIdx) : match;
    }

    private static String getVariableValueAsString(Object variableValue) {
        return variableValue != null ? variableValue.toString() : "";
    }

    private static class VarArgsTemplateVariables
    implements UriTemplateVariables {
        private final Iterator<Object> valueIterator;

        public VarArgsTemplateVariables(Object ... uriVariableValues) {
            this.valueIterator = Arrays.asList(uriVariableValues).iterator();
        }

        @Override
        public Object getValue(String name) {
            if (!this.valueIterator.hasNext()) {
                throw new IllegalArgumentException("Not enough variable values available to expand '" + name + "'");
            }
            return this.valueIterator.next();
        }
    }

    private static class MapTemplateVariables
    implements UriTemplateVariables {
        private final Map<String, ?> uriVariables;

        public MapTemplateVariables(Map<String, ?> uriVariables) {
            this.uriVariables = uriVariables;
        }

        @Override
        public Object getValue(String name) {
            if (!this.uriVariables.containsKey(name)) {
                throw new IllegalArgumentException("Map has no value for '" + name + "'");
            }
            return this.uriVariables.get(name);
        }
    }

    public static interface UriTemplateVariables {
        public Object getValue(String var1);
    }
}

