/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.reactive.function.server;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.function.Function;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;
import org.springframework.core.io.UrlResource;
import org.springframework.http.server.PathContainer;
import org.springframework.util.Assert;
import org.springframework.util.ResourceUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.reactive.function.server.ServerRequest;
import org.springframework.web.util.pattern.PathPattern;
import org.springframework.web.util.pattern.PathPatternParser;
import reactor.core.publisher.Mono;

class PathResourceLookupFunction
implements Function<ServerRequest, Mono<Resource>> {
    private final PathPattern pattern;
    private final Resource location;

    public PathResourceLookupFunction(String pattern, Resource location) {
        Assert.hasLength((String)pattern, (String)"'pattern' must not be empty");
        Assert.notNull((Object)location, (String)"'location' must not be null");
        this.pattern = PathPatternParser.defaultInstance.parse(pattern);
        this.location = location;
    }

    @Override
    public Mono<Resource> apply(ServerRequest request) {
        PathContainer pathContainer = request.requestPath().pathWithinApplication();
        if (!this.pattern.matches(pathContainer)) {
            return Mono.empty();
        }
        String path = this.processPath((pathContainer = this.pattern.extractPathWithinPattern(pathContainer)).value());
        if (path.contains("%")) {
            path = StringUtils.uriDecode((String)path, (Charset)StandardCharsets.UTF_8);
        }
        if (!StringUtils.hasLength((String)path) || this.isInvalidPath(path)) {
            return Mono.empty();
        }
        try {
            Resource resource = this.location.createRelative(path);
            if (resource.isReadable() && this.isResourceUnderLocation(resource)) {
                return Mono.just((Object)resource);
            }
            return Mono.empty();
        }
        catch (IOException ex) {
            throw new UncheckedIOException(ex);
        }
    }

    private String processPath(String path) {
        boolean slash = false;
        for (int i2 = 0; i2 < ((String)path).length(); ++i2) {
            if (((String)path).charAt(i2) == '/') {
                slash = true;
                continue;
            }
            if (((String)path).charAt(i2) <= ' ' || ((String)path).charAt(i2) == '\u007f') continue;
            if (i2 == 0 || i2 == 1 && slash) {
                return path;
            }
            path = slash ? "/" + ((String)path).substring(i2) : ((String)path).substring(i2);
            return path;
        }
        return slash ? "/" : "";
    }

    private boolean isInvalidPath(String path) {
        if (path.contains("WEB-INF") || path.contains("META-INF")) {
            return true;
        }
        if (path.contains(":/")) {
            String relativePath;
            String string = relativePath = path.charAt(0) == '/' ? path.substring(1) : path;
            if (ResourceUtils.isUrl((String)relativePath) || relativePath.startsWith("url:")) {
                return true;
            }
        }
        return path.contains("..") && StringUtils.cleanPath((String)path).contains("../");
    }

    private boolean isResourceUnderLocation(Resource resource) throws IOException {
        String locationPath;
        String resourcePath;
        if (resource.getClass() != this.location.getClass()) {
            return false;
        }
        if (resource instanceof UrlResource) {
            resourcePath = resource.getURL().toExternalForm();
            locationPath = StringUtils.cleanPath((String)this.location.getURL().toString());
        } else if (resource instanceof ClassPathResource) {
            resourcePath = ((ClassPathResource)resource).getPath();
            locationPath = StringUtils.cleanPath((String)((ClassPathResource)this.location).getPath());
        } else {
            resourcePath = resource.getURL().getPath();
            locationPath = StringUtils.cleanPath((String)this.location.getURL().getPath());
        }
        if (locationPath.equals(resourcePath)) {
            return true;
        }
        String string = locationPath = locationPath.endsWith("/") || locationPath.isEmpty() ? locationPath : locationPath + "/";
        if (!resourcePath.startsWith(locationPath)) {
            return false;
        }
        return !resourcePath.contains("%") || !StringUtils.uriDecode((String)resourcePath, (Charset)StandardCharsets.UTF_8).contains("../");
    }

    public String toString() {
        return this.pattern + " -> " + this.location;
    }
}

