/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.reactive.socket.client;

import java.net.URI;
import java.security.Principal;
import java.util.function.Supplier;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.io.buffer.Netty5DataBufferFactory;
import org.springframework.http.HttpHeaders;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import org.springframework.web.reactive.socket.HandshakeInfo;
import org.springframework.web.reactive.socket.WebSocketHandler;
import org.springframework.web.reactive.socket.adapter.ReactorNetty2WebSocketSession;
import org.springframework.web.reactive.socket.client.WebSocketClient;
import reactor.core.publisher.Mono;
import reactor.netty5.http.client.HttpClient;
import reactor.netty5.http.client.WebsocketClientSpec;
import reactor.netty5.http.websocket.WebsocketInbound;
import reactor.netty5.http.websocket.WebsocketOutbound;

public class ReactorNetty2WebSocketClient
implements WebSocketClient {
    private static final Log logger = LogFactory.getLog(ReactorNetty2WebSocketClient.class);
    private final HttpClient httpClient;
    private final Supplier<WebsocketClientSpec.Builder> specBuilderSupplier;
    @Nullable
    private Boolean handlePing;

    public ReactorNetty2WebSocketClient() {
        this(HttpClient.create());
    }

    public ReactorNetty2WebSocketClient(HttpClient httpClient) {
        this(httpClient, (Supplier<WebsocketClientSpec.Builder>)WebsocketClientSpec.builder());
    }

    public ReactorNetty2WebSocketClient(HttpClient httpClient, Supplier<WebsocketClientSpec.Builder> builderSupplier) {
        Assert.notNull((Object)httpClient, (String)"HttpClient is required");
        Assert.notNull(builderSupplier, (String)"WebsocketClientSpec.Builder is required");
        this.httpClient = httpClient;
        this.specBuilderSupplier = builderSupplier;
    }

    public HttpClient getHttpClient() {
        return this.httpClient;
    }

    public WebsocketClientSpec getWebsocketClientSpec() {
        return this.buildSpec(null);
    }

    private WebsocketClientSpec buildSpec(@Nullable String protocols) {
        WebsocketClientSpec.Builder builder = this.specBuilderSupplier.get();
        if (StringUtils.hasText((String)protocols)) {
            builder.protocols(protocols);
        }
        return builder.build();
    }

    @Override
    public Mono<Void> execute(URI url, WebSocketHandler handler) {
        return this.execute(url, new HttpHeaders(), handler);
    }

    @Override
    public Mono<Void> execute(URI url, HttpHeaders requestHeaders, WebSocketHandler handler) {
        String protocols = StringUtils.collectionToCommaDelimitedString(handler.getSubProtocols());
        WebsocketClientSpec clientSpec = this.buildSpec(protocols);
        return ((HttpClient.WebsocketSender)this.getHttpClient().headers(nettyHeaders -> this.setNettyHeaders(requestHeaders, (io.netty5.handler.codec.http.headers.HttpHeaders)nettyHeaders)).websocket(clientSpec).uri(url.toString())).handle((inbound, outbound) -> {
            HttpHeaders responseHeaders = this.toHttpHeaders((WebsocketInbound)inbound);
            String protocol = responseHeaders.getFirst("Sec-WebSocket-Protocol");
            HandshakeInfo info = new HandshakeInfo(url, responseHeaders, (Mono<Principal>)Mono.empty(), protocol);
            Netty5DataBufferFactory factory = new Netty5DataBufferFactory(outbound.alloc());
            ReactorNetty2WebSocketSession session = new ReactorNetty2WebSocketSession((WebsocketInbound)inbound, (WebsocketOutbound)outbound, info, factory, clientSpec.maxFramePayloadLength());
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Started session '" + session.getId() + "' for " + url));
            }
            return handler.handle(session).checkpoint(url + " [ReactorNetty2WebSocketClient]");
        }).doOnRequest(n -> {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Connecting to " + url));
            }
        }).next();
    }

    private void setNettyHeaders(HttpHeaders httpHeaders, io.netty5.handler.codec.http.headers.HttpHeaders nettyHeaders) {
        httpHeaders.forEach((arg_0, arg_1) -> ((io.netty5.handler.codec.http.headers.HttpHeaders)nettyHeaders).set(arg_0, arg_1));
    }

    private HttpHeaders toHttpHeaders(WebsocketInbound inbound) {
        HttpHeaders headers = new HttpHeaders();
        inbound.headers().iterator().forEachRemaining(entry -> headers.add(((CharSequence)entry.getKey()).toString(), ((CharSequence)entry.getValue()).toString()));
        return headers;
    }
}

