/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.mvc.multiaction;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.springframework.context.ApplicationContextException;
import org.springframework.web.bind.ServletRequestDataBinder;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.mvc.AbstractController;
import org.springframework.web.servlet.mvc.LastModified;
import org.springframework.web.servlet.mvc.SessionRequiredException;
import org.springframework.web.servlet.mvc.multiaction.InternalPathMethodNameResolver;
import org.springframework.web.servlet.mvc.multiaction.MethodNameResolver;
import org.springframework.web.servlet.mvc.multiaction.NoSuchRequestHandlingMethodException;

public class MultiActionController
extends AbstractController
implements LastModified {
    public static final String LAST_MODIFIED_METHOD_SUFFIX = "LastModified";
    private MethodNameResolver methodNameResolver = new InternalPathMethodNameResolver();
    private Object delegate;
    private Map methodHash;
    private Map lastModifiedMethodHash;
    private Map exceptionHandlerHash;
    static /* synthetic */ Class class$org$springframework$web$servlet$ModelAndView;
    static /* synthetic */ Class class$javax$servlet$http$HttpServletRequest;
    static /* synthetic */ Class class$javax$servlet$http$HttpServletResponse;
    static /* synthetic */ Class class$java$lang$Throwable;
    static /* synthetic */ Class class$javax$servlet$http$HttpSession;

    public MultiActionController() throws ApplicationContextException {
        this.setDelegate(this);
    }

    public MultiActionController(Object delegate) throws ApplicationContextException {
        this.setDelegate(delegate);
    }

    public final void setMethodNameResolver(MethodNameResolver methodNameResolver) {
        this.methodNameResolver = methodNameResolver;
    }

    public final MethodNameResolver getMethodNameResolver() {
        return this.methodNameResolver;
    }

    public final void setDelegate(Object delegate) throws ApplicationContextException {
        Class<?>[] params;
        int i;
        if (delegate == null) {
            throw new IllegalArgumentException("Delegate cannot be null in MultiActionController");
        }
        this.delegate = delegate;
        this.methodHash = new HashMap();
        this.lastModifiedMethodHash = new HashMap();
        Method[] methods = delegate.getClass().getMethods();
        for (i = 0; i < methods.length; ++i) {
            if (!methods[i].getReturnType().equals(class$org$springframework$web$servlet$ModelAndView == null ? MultiActionController.class$("org.springframework.web.servlet.ModelAndView") : class$org$springframework$web$servlet$ModelAndView) || (params = methods[i].getParameterTypes()).length < 2 || !params[0].equals(class$javax$servlet$http$HttpServletRequest == null ? MultiActionController.class$("javax.servlet.http.HttpServletRequest") : class$javax$servlet$http$HttpServletRequest) || !params[1].equals(class$javax$servlet$http$HttpServletResponse == null ? MultiActionController.class$("javax.servlet.http.HttpServletResponse") : class$javax$servlet$http$HttpServletResponse)) continue;
            this.logger.info((Object)("Found action method [" + methods[i] + "]"));
            this.methodHash.put(methods[i].getName(), methods[i]);
            try {
                Method lastModifiedMethod = delegate.getClass().getMethod(methods[i].getName() + LAST_MODIFIED_METHOD_SUFFIX, class$javax$servlet$http$HttpServletRequest == null ? MultiActionController.class$("javax.servlet.http.HttpServletRequest") : class$javax$servlet$http$HttpServletRequest);
                this.lastModifiedMethodHash.put(methods[i].getName(), lastModifiedMethod);
                this.logger.info((Object)("Found last modified method for action method [" + methods[i] + "]"));
                continue;
            }
            catch (NoSuchMethodException ex) {
                // empty catch block
            }
        }
        if (this.methodHash.isEmpty()) {
            throw new ApplicationContextException("No handler methods in class " + this.getClass().getName());
        }
        this.exceptionHandlerHash = new HashMap();
        for (i = 0; i < methods.length; ++i) {
            if (!methods[i].getReturnType().equals(class$org$springframework$web$servlet$ModelAndView == null ? MultiActionController.class$("org.springframework.web.servlet.ModelAndView") : class$org$springframework$web$servlet$ModelAndView) || methods[i].getParameterTypes().length != 3 || !(params = methods[i].getParameterTypes())[0].equals(class$javax$servlet$http$HttpServletRequest == null ? MultiActionController.class$("javax.servlet.http.HttpServletRequest") : class$javax$servlet$http$HttpServletRequest) || !params[1].equals(class$javax$servlet$http$HttpServletResponse == null ? MultiActionController.class$("javax.servlet.http.HttpServletResponse") : class$javax$servlet$http$HttpServletResponse) || !(class$java$lang$Throwable == null ? MultiActionController.class$("java.lang.Throwable") : class$java$lang$Throwable).isAssignableFrom(params[2])) continue;
            this.exceptionHandlerHash.put(params[2], methods[i]);
            this.logger.info((Object)("Found exception handler method [" + methods[i] + "]"));
        }
    }

    public final long getLastModified(HttpServletRequest request) {
        try {
            String handlerMethodName = this.methodNameResolver.getHandlerMethodName(request);
            Method lastModifiedMethod = (Method)this.lastModifiedMethodHash.get(handlerMethodName);
            if (lastModifiedMethod != null) {
                try {
                    Long wrappedLong = (Long)lastModifiedMethod.invoke(this.delegate, request);
                    return wrappedLong;
                }
                catch (Exception ex) {
                    this.logger.error((Object)"Failed to invoke lastModified method", (Throwable)ex);
                }
            }
        }
        catch (NoSuchRequestHandlingMethodException noSuchRequestHandlingMethodException) {
            // empty catch block
        }
        return -1L;
    }

    protected ModelAndView handleRequestInternal(HttpServletRequest request, HttpServletResponse response) throws Exception {
        String name = this.methodNameResolver.getHandlerMethodName(request);
        return this.invokeNamedMethod(name, request, response);
    }

    protected final ModelAndView invokeNamedMethod(String method, HttpServletRequest request, HttpServletResponse response) throws Exception {
        Method m = (Method)this.methodHash.get(method);
        if (m == null) {
            throw new NoSuchRequestHandlingMethodException(method, this);
        }
        try {
            LinkedList<Object> params = new LinkedList<Object>();
            params.add(request);
            params.add(response);
            if (m.getParameterTypes().length >= 3 && m.getParameterTypes()[2].equals(class$javax$servlet$http$HttpSession == null ? (class$javax$servlet$http$HttpSession = MultiActionController.class$("javax.servlet.http.HttpSession")) : class$javax$servlet$http$HttpSession)) {
                HttpSession session = request.getSession(false);
                if (session == null) {
                    return this.handleException(request, response, (Throwable)((Object)new SessionRequiredException("Session was required for method '" + method + "'")));
                }
                params.add(session);
            }
            if (m.getParameterTypes().length >= 3 && !m.getParameterTypes()[m.getParameterTypes().length - 1].equals(class$javax$servlet$http$HttpSession == null ? (class$javax$servlet$http$HttpSession = MultiActionController.class$("javax.servlet.http.HttpSession")) : class$javax$servlet$http$HttpSession)) {
                Object command = this.newCommandObject(m.getParameterTypes()[m.getParameterTypes().length - 1]);
                params.add(command);
                this.bind((ServletRequest)request, command);
            }
            Object[] parray = params.toArray(new Object[params.size()]);
            return (ModelAndView)m.invoke(this.delegate, parray);
        }
        catch (InvocationTargetException ex) {
            Throwable t = ex.getTargetException();
            return this.handleException(request, response, t);
        }
    }

    private ModelAndView handleException(HttpServletRequest request, HttpServletResponse response, Throwable t) throws Exception {
        Method handler = this.getExceptionHandler(t);
        if (handler != null) {
            return this.invokeExceptionHandler(handler, request, response, t);
        }
        if (t instanceof Exception) {
            throw (Exception)t;
        }
        if (t instanceof Error) {
            throw (Error)t;
        }
        throw new ServletException("Unknown Throwable type encountered: " + t);
    }

    protected Object newCommandObject(Class clazz) throws ServletException {
        this.logger.info((Object)("Must create new command of " + clazz));
        try {
            Object command = clazz.newInstance();
            return command;
        }
        catch (Exception ex) {
            throw new ServletException("Cannot instantiate command " + clazz + "; does it have a public no arg constructor?", (Throwable)ex);
        }
    }

    protected void bind(ServletRequest request, Object command) throws ServletException {
        this.logger.info((Object)"Binding request parameters onto command");
        ServletRequestDataBinder binder = new ServletRequestDataBinder(command, "command");
        binder.bind(request);
        binder.closeNoCatch();
    }

    protected Method getExceptionHandler(Throwable exception) {
        Class<?> exceptionClass = exception.getClass();
        this.logger.info((Object)("Trying to find handler for exception of " + exceptionClass));
        Method handler = (Method)this.exceptionHandlerHash.get(exceptionClass);
        while (handler == null && !exceptionClass.equals(class$java$lang$Throwable == null ? MultiActionController.class$("java.lang.Throwable") : class$java$lang$Throwable)) {
            this.logger.info((Object)("Looking at superclass " + exceptionClass));
            exceptionClass = exceptionClass.getSuperclass();
            handler = (Method)this.exceptionHandlerHash.get(exceptionClass);
        }
        return handler;
    }

    private ModelAndView invokeExceptionHandler(Method handler, HttpServletRequest request, HttpServletResponse response, Throwable exception) throws Exception {
        if (handler == null) {
            throw new ServletException("No handler for exception", exception);
        }
        this.logger.info((Object)("Invoking exception handler [" + handler + "] for exception [" + exception + "]"));
        try {
            ModelAndView mv = (ModelAndView)handler.invoke(this.delegate, request, response, exception);
            return mv;
        }
        catch (InvocationTargetException ex) {
            Throwable t = ex.getTargetException();
            if (t instanceof Exception) {
                throw (Exception)t;
            }
            if (t instanceof Error) {
                throw (Error)t;
            }
            throw new ServletException("Unknown Throwable type encountered: " + t);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

