/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.view.freemarker;

import freemarker.template.Configuration;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import java.io.IOException;
import java.io.Writer;
import java.util.Locale;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactoryUtils;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.context.ApplicationContextException;
import org.springframework.web.servlet.support.RequestContextUtils;
import org.springframework.web.servlet.view.AbstractUrlBasedView;
import org.springframework.web.servlet.view.freemarker.FreeMarkerConfig;

public class FreeMarkerView
extends AbstractUrlBasedView {
    private String encoding;
    private Configuration configuration;
    static /* synthetic */ Class class$org$springframework$web$servlet$view$freemarker$FreeMarkerConfig;

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    protected String getEncoding() {
        return this.encoding;
    }

    public void setConfiguration(Configuration configration) {
        this.configuration = configration;
    }

    protected Configuration getConfiguration() {
        return this.configuration;
    }

    protected void initApplicationContext() throws BeansException {
        super.initApplicationContext();
        if (this.configuration == null) {
            try {
                FreeMarkerConfig freemarkerConfig = (FreeMarkerConfig)BeanFactoryUtils.beanOfTypeIncludingAncestors((ListableBeanFactory)this.getApplicationContext(), (Class)(class$org$springframework$web$servlet$view$freemarker$FreeMarkerConfig == null ? (class$org$springframework$web$servlet$view$freemarker$FreeMarkerConfig = FreeMarkerView.class$("org.springframework.web.servlet.view.freemarker.FreeMarkerConfig")) : class$org$springframework$web$servlet$view$freemarker$FreeMarkerConfig), (boolean)true, (boolean)true);
                this.configuration = freemarkerConfig.getConfiguration();
            }
            catch (NoSuchBeanDefinitionException ex) {
                throw new ApplicationContextException("Must define a single FreeMarkerConfig bean in this web application context (may be inherited): FreeMarkerConfigurer is the usual implementation. This bean may be given any name.", (Throwable)ex);
            }
        }
        try {
            this.getTemplate(this.configuration.getLocale());
        }
        catch (IOException ex) {
            throw new ApplicationContextException("Cannot load FreeMarker template for URL [" + this.getUrl() + "]: Did you specify the correct template loader path?");
        }
    }

    protected void renderMergedOutputModel(Map model, HttpServletRequest request, HttpServletResponse response) throws IOException, TemplateException {
        Template template = this.getTemplate(RequestContextUtils.getLocale(request));
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Preparing to process FreeMarker template [" + template.getName() + "] with model [" + model + "] "));
        }
        response.setContentType(this.getContentType());
        this.processTemplate(template, model, response);
    }

    protected Template getTemplate(Locale locale) throws IOException {
        return this.encoding != null ? this.configuration.getTemplate(this.getUrl(), locale, this.encoding) : this.configuration.getTemplate(this.getUrl(), locale);
    }

    protected void processTemplate(Template template, Map model, HttpServletResponse response) throws IOException, TemplateException {
        template.process((Object)model, (Writer)response.getWriter());
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

