/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet;

import java.util.HashMap;
import java.util.Map;
import org.springframework.web.servlet.View;

public class ModelAndView {
    private View view;
    private String viewName;
    private Map model;

    public ModelAndView(View view) {
        this.view = view;
    }

    public ModelAndView(String viewName) {
        this.viewName = viewName;
    }

    public ModelAndView(View view, Map model) {
        this.view = view;
        this.model = model;
    }

    public ModelAndView(String viewName, Map model) {
        this.viewName = viewName;
        this.model = model;
    }

    public ModelAndView(View view, String modelName, Object modelObject) {
        this.view = view;
        this.addObject(modelName, modelObject);
    }

    public ModelAndView(String viewName, String modelName, Object modelObject) {
        this.viewName = viewName;
        this.addObject(modelName, modelObject);
    }

    public void setView(View view) {
        this.view = view;
        this.viewName = null;
    }

    public View getView() {
        return this.view;
    }

    public void setViewName(String viewName) {
        this.viewName = viewName;
        this.view = null;
    }

    public String getViewName() {
        return this.viewName;
    }

    public boolean isReference() {
        return this.viewName != null;
    }

    protected Map getModelInternal() {
        return this.model;
    }

    public Map getModel() {
        if (this.model == null) {
            this.model = new HashMap(1);
        }
        return this.model;
    }

    public ModelAndView addObject(String modelName, Object modelObject) {
        this.getModel().put(modelName, modelObject);
        return this;
    }

    public ModelAndView addAllObjects(Map modelMap) {
        this.getModel().putAll(modelMap);
        return this;
    }

    public void clear() {
        this.view = null;
        this.viewName = null;
        this.model = null;
    }

    public boolean isEmpty() {
        return this.view == null && this.viewName == null && this.model == null;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer("ModelAndView: ");
        if (this.isReference()) {
            buf.append("reference to view with name '").append(this.viewName).append("'");
        } else {
            buf.append("materialized View is [").append(this.view).append(']');
        }
        buf.append("; model is ").append(this.model);
        return buf.toString();
    }
}

