/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.view;

import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.springframework.context.ApplicationContextAware;
import org.springframework.web.context.support.WebApplicationObjectSupport;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.ViewResolver;

public abstract class AbstractCachingViewResolver
extends WebApplicationObjectSupport
implements ViewResolver {
    private final Map viewMap = Collections.synchronizedMap(new HashMap());
    private boolean cache = true;

    public void setCache(boolean cache) {
        this.cache = cache;
    }

    public boolean isCache() {
        return this.cache;
    }

    public View resolveViewName(String viewName, Locale locale) throws Exception {
        if (!this.cache) {
            this.logger.warn((Object)"View caching is SWITCHED OFF -- DEVELOPMENT SETTING ONLY: This can severely impair performance");
            return this.prepareView(viewName, locale);
        }
        String cacheKey = this.getCacheKey(viewName, locale);
        View view = (View)this.viewMap.get(cacheKey);
        if (view == null) {
            view = this.prepareView(viewName, locale);
            this.viewMap.put(cacheKey, view);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Cached view '" + cacheKey + "'"));
            }
        }
        return view;
    }

    public void removeFromCache(String viewName, Locale locale) {
        if (!this.cache) {
            this.logger.warn((Object)"View caching is SWITCHED OFF -- removal not necessary");
        } else {
            String cacheKey = this.getCacheKey(viewName, locale);
            if (this.viewMap.remove(cacheKey) == null) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("No cached instance for view '" + cacheKey + "' was found"));
                }
            } else if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Cach for view " + cacheKey + " has been cleared"));
            }
        }
    }

    protected String getCacheKey(String viewName, Locale locale) {
        return viewName + "_" + locale;
    }

    private View prepareView(String viewName, Locale locale) throws Exception {
        View view = this.createView(viewName, locale);
        if (view instanceof ApplicationContextAware) {
            ((ApplicationContextAware)view).setApplicationContext(this.getApplicationContext());
        }
        return view;
    }

    protected View createView(String viewName, Locale locale) throws Exception {
        return this.loadView(viewName, locale);
    }

    protected abstract View loadView(String var1, Locale var2) throws Exception;
}

