/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.config;

import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.xml.BeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.http.HttpMethod;
import org.springframework.util.StringUtils;
import org.springframework.util.xml.DomUtils;
import org.springframework.web.cors.CorsConfiguration;
import org.springframework.web.servlet.config.MvcNamespaceUtils;
import org.w3c.dom.Element;

public class CorsBeanDefinitionParser
implements BeanDefinitionParser {
    private static final List<String> DEFAULT_ALLOWED_ORIGINS = Arrays.asList("*");
    private static final List<String> DEFAULT_ALLOWED_METHODS = Arrays.asList(HttpMethod.GET.name(), HttpMethod.HEAD.name(), HttpMethod.POST.name());
    private static final List<String> DEFAULT_ALLOWED_HEADERS = Arrays.asList("*");
    private static final boolean DEFAULT_ALLOW_CREDENTIALS = true;
    private static final long DEFAULT_MAX_AGE = 1600L;

    public BeanDefinition parse(Element element, ParserContext parserContext) {
        LinkedHashMap<String, CorsConfiguration> corsConfigurations = new LinkedHashMap<String, CorsConfiguration>();
        List mappings = DomUtils.getChildElementsByTagName((Element)element, (String)"mapping");
        if (mappings.isEmpty()) {
            CorsConfiguration config = new CorsConfiguration();
            config.setAllowedOrigins(DEFAULT_ALLOWED_ORIGINS);
            config.setAllowedMethods(DEFAULT_ALLOWED_METHODS);
            config.setAllowedHeaders(DEFAULT_ALLOWED_HEADERS);
            config.setAllowCredentials(Boolean.valueOf(true));
            config.setMaxAge(Long.valueOf(1600L));
            corsConfigurations.put("/**", config);
        } else {
            for (Element mapping : mappings) {
                CorsConfiguration config = new CorsConfiguration();
                if (mapping.hasAttribute("allowed-origins")) {
                    String[] allowedOrigins = StringUtils.tokenizeToStringArray((String)mapping.getAttribute("allowed-origins"), (String)",");
                    config.setAllowedOrigins(Arrays.asList(allowedOrigins));
                } else {
                    config.setAllowedOrigins(DEFAULT_ALLOWED_ORIGINS);
                }
                if (mapping.hasAttribute("allowed-methods")) {
                    String[] allowedMethods = StringUtils.tokenizeToStringArray((String)mapping.getAttribute("allowed-methods"), (String)",");
                    config.setAllowedMethods(Arrays.asList(allowedMethods));
                } else {
                    config.setAllowedMethods(DEFAULT_ALLOWED_METHODS);
                }
                if (mapping.hasAttribute("allowed-headers")) {
                    String[] allowedHeaders = StringUtils.tokenizeToStringArray((String)mapping.getAttribute("allowed-headers"), (String)",");
                    config.setAllowedHeaders(Arrays.asList(allowedHeaders));
                } else {
                    config.setAllowedHeaders(DEFAULT_ALLOWED_HEADERS);
                }
                if (mapping.hasAttribute("exposed-headers")) {
                    String[] exposedHeaders = StringUtils.tokenizeToStringArray((String)mapping.getAttribute("exposed-headers"), (String)",");
                    config.setExposedHeaders(Arrays.asList(exposedHeaders));
                }
                if (mapping.hasAttribute("allow-credentials")) {
                    config.setAllowCredentials(Boolean.valueOf(Boolean.parseBoolean(mapping.getAttribute("allow-credentials"))));
                } else {
                    config.setAllowCredentials(Boolean.valueOf(true));
                }
                if (mapping.hasAttribute("max-age")) {
                    config.setMaxAge(Long.valueOf(Long.parseLong(mapping.getAttribute("max-age"))));
                } else {
                    config.setMaxAge(Long.valueOf(1600L));
                }
                corsConfigurations.put(mapping.getAttribute("path"), config);
            }
        }
        MvcNamespaceUtils.registerCorsConfigurations(corsConfigurations, parserContext, parserContext.extractSource((Object)element));
        return null;
    }
}

