/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.mvc.method.annotation;

import jakarta.servlet.ServletRequest;
import java.util.Map;
import java.util.Set;
import org.springframework.beans.MutablePropertyValues;
import org.springframework.lang.Nullable;
import org.springframework.web.bind.ServletRequestDataBinder;
import org.springframework.web.bind.WebDataBinder;
import org.springframework.web.servlet.HandlerMapping;

public class ExtendedServletRequestDataBinder
extends ServletRequestDataBinder {
    public ExtendedServletRequestDataBinder(@Nullable Object target) {
        super(target);
    }

    public ExtendedServletRequestDataBinder(@Nullable Object target, String objectName) {
        super(target, objectName);
    }

    protected ServletRequestDataBinder.ServletRequestValueResolver createValueResolver(ServletRequest request) {
        return new ExtendedServletRequestValueResolver(request, (WebDataBinder)this);
    }

    protected void addBindValues(MutablePropertyValues mpvs, ServletRequest request) {
        Map<String, String> uriVars = ExtendedServletRequestDataBinder.getUriVars(request);
        if (uriVars != null) {
            uriVars.forEach((name, value) -> {
                if (mpvs.contains(name)) {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("URI variable '" + name + "' overridden by request bind value."));
                    }
                } else {
                    mpvs.addPropertyValue(name, value);
                }
            });
        }
    }

    @Nullable
    private static Map<String, String> getUriVars(ServletRequest request) {
        String attr = HandlerMapping.URI_TEMPLATE_VARIABLES_ATTRIBUTE;
        return (Map)request.getAttribute(attr);
    }

    private static class ExtendedServletRequestValueResolver
    extends ServletRequestDataBinder.ServletRequestValueResolver {
        ExtendedServletRequestValueResolver(ServletRequest request, WebDataBinder dataBinder) {
            super(request, dataBinder);
        }

        protected Object getRequestParameter(String name, Class<?> type) {
            Map<String, String> uriVars;
            Object value = super.getRequestParameter(name, type);
            if (value == null && (uriVars = ExtendedServletRequestDataBinder.getUriVars(this.getRequest())) != null) {
                value = uriVars.get(name);
            }
            return value;
        }

        protected Set<String> initParameterNames(ServletRequest request) {
            Set set = super.initParameterNames(request);
            Map<String, String> uriVars = ExtendedServletRequestDataBinder.getUriVars(this.getRequest());
            if (uriVars != null) {
                set.addAll(uriVars.keySet());
            }
            return set;
        }
    }
}

