/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.test.mixins;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.switchyard.common.io.pull.PropertiesPuller;
import org.switchyard.common.lang.Strings;
import org.switchyard.common.type.Classes;
import org.switchyard.exception.SwitchYardException;
import org.switchyard.test.mixins.AbstractTestMixIn;

public class BPMMixIn
extends AbstractTestMixIn {
    private final boolean _managedLifecycle;
    private Object _service = null;
    private Object _server = null;
    private Object _client = null;
    private String _host = "127.0.0.1";
    private int _port = 9123;
    private String _groupsPath = "/roles.properties";

    public BPMMixIn() {
        this(true);
    }

    public BPMMixIn(boolean managedLifecycle) {
        this._managedLifecycle = managedLifecycle;
    }

    public String getHost() {
        return this._host;
    }

    public BPMMixIn setHost(String host) {
        this._host = host;
        return this;
    }

    public int getPort() {
        return this._port;
    }

    public BPMMixIn setPort(int port) {
        this._port = port;
        return this;
    }

    public String getGroupsPath() {
        return this._groupsPath;
    }

    public BPMMixIn setGroupsPath(String groupsPath) {
        this._groupsPath = groupsPath;
        return this;
    }

    @Override
    public void initialize() {
        if (this._managedLifecycle) {
            this.startTaskServer();
        }
    }

    @Override
    public void uninitialize() {
        if (this._managedLifecycle) {
            this.stopTaskServer();
        }
    }

    private Object getService() {
        if (this._service == null) {
            Class serviceClass = Classes.forName((String)"org.switchyard.component.bpm.task.service.TaskService", BPMMixIn.class);
            try {
                this._service = serviceClass.getMethod("instance", new Class[0]).invoke(null, new Object[0]);
            }
            catch (Throwable t) {
                throw new SwitchYardException(t);
            }
        }
        return this._service;
    }

    public void startTaskServer() {
        if (this._server == null) {
            Object service = this.getService();
            try {
                this._server = service.getClass().getMethod("newTaskServer", new Class[0]).invoke(service, new Object[0]);
                Class<?> serverClass = this._server.getClass();
                serverClass.getMethod("setHost", String.class).invoke(this._server, this.getHost());
                serverClass.getMethod("setPort", Integer.TYPE).invoke(this._server, this.getPort());
                serverClass.getMethod("start", new Class[0]).invoke(this._server, new Object[0]);
            }
            catch (Throwable t) {
                throw new SwitchYardException(t);
            }
        }
    }

    public void stopTaskServer() {
        if (this._server != null) {
            try {
                this._server.getClass().getMethod("stop", new Class[0]).invoke(this._server, new Object[0]);
            }
            catch (Throwable t) {
                throw new SwitchYardException(t);
            }
            finally {
                this._server = null;
            }
        }
    }

    public void connectTaskClient() {
        if (this._client == null) {
            Object service = this.getService();
            try {
                this._client = service.getClass().getMethod("newTaskClient", new Class[0]).invoke(service, new Object[0]);
                Class<?> clientClass = this._client.getClass();
                clientClass.getMethod("setHost", String.class).invoke(this._client, this.getHost());
                clientClass.getMethod("setPort", Integer.TYPE).invoke(this._client, this.getPort());
                clientClass.getMethod("connect", new Class[0]).invoke(this._client, new Object[0]);
            }
            catch (Throwable t) {
                throw new SwitchYardException(t);
            }
        }
    }

    public void disconnectTaskClient() {
        if (this._client != null) {
            try {
                this._client.getClass().getMethod("disconnect", new Class[0]).invoke(this._client, new Object[0]);
            }
            catch (Throwable t) {
                throw new SwitchYardException(t);
            }
            finally {
                this._client = null;
            }
        }
    }

    public Map<String, List<String>> getUsersGroups() {
        return this.getUsersGroups(this.getGroupsPath());
    }

    public Map<String, List<String>> getUsersGroups(String groupsPath) {
        Properties usersGroupsProps;
        HashMap<String, List<String>> usersGroupsMap = new HashMap<String, List<String>>();
        try {
            usersGroupsProps = (Properties)new PropertiesPuller().pull(groupsPath, BPMMixIn.class);
        }
        catch (IOException ioe) {
            throw new SwitchYardException((Throwable)ioe);
        }
        for (Object userKey : usersGroupsProps.keySet()) {
            String user = (String)userKey;
            if ("Administrator".equals(user)) continue;
            List groups = Strings.splitTrimToNull((String)usersGroupsProps.getProperty(user), (String)",");
            usersGroupsMap.put(user, groups);
        }
        return usersGroupsMap;
    }

    public void completeHumanTasks() {
        this.completeHumanTasks(this.getUsersGroups());
    }

    public void completeHumanTasks(String groupsPath) {
        this.completeHumanTasks(this.getUsersGroups(groupsPath));
    }

    public void completeHumanTasks(Map<String, List<String>> usersGroups) {
        boolean keepWorking;
        while (keepWorking = this.doCompleteHumanTasks(usersGroups)) {
        }
    }

    private boolean doCompleteHumanTasks(Map<String, List<String>> usersGroups) {
        boolean keepWorking = false;
        try {
            Class<?> taskClientClass = this._client.getClass();
            Class taskContentClass = Classes.forName((String)"org.switchyard.component.bpm.task.service.TaskContent", BPMMixIn.class);
            Class taskStatusClass = Classes.forName((String)"org.switchyard.component.bpm.task.service.TaskStatus", BPMMixIn.class);
            Object completed = taskStatusClass.getDeclaredField("COMPLETED").get(null);
            for (String userId : usersGroups.keySet()) {
                List<String> groupIds = usersGroups.get(userId);
                List tasks = (List)taskClientClass.getMethod("getTasksAssignedAsPotentialOwner", String.class, List.class).invoke(this._client, userId, groupIds);
                for (Object task : tasks) {
                    Object status = task.getClass().getMethod("getStatus", new Class[0]).invoke(task, new Object[0]);
                    if (completed.equals(status)) continue;
                    Long taskId = (Long)task.getClass().getMethod("getId", new Class[0]).invoke(task, new Object[0]);
                    taskClientClass.getMethod("claim", Long.class, String.class, List.class).invoke(this._client, taskId, userId, groupIds);
                    taskClientClass.getMethod("start", Long.class, String.class).invoke(this._client, taskId, userId);
                    taskClientClass.getMethod("complete", Long.class, String.class, taskContentClass).invoke(this._client, taskId, userId, null);
                    keepWorking = true;
                }
            }
            Thread.sleep(1000L);
        }
        catch (Throwable t) {
            throw new SwitchYardException(t);
        }
        return keepWorking;
    }
}

