/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.test;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.activation.DataSource;

public class TestDataSource
implements DataSource,
Serializable {
    private static final Charset UTF8 = Charset.forName("UTF-8");
    private String _name;
    private String _contentType;
    private byte[] _data;
    private final ReadWriteLock _dataLock = new ReentrantReadWriteLock();

    public TestDataSource() {
    }

    public TestDataSource(String name) {
        this.setName(name);
    }

    public TestDataSource(String name, String contentType) {
        this.setName(name).setContentType(contentType);
    }

    public TestDataSource(String name, String contentType, byte[] data) {
        this.setName(name).setContentType(contentType).setData(data);
    }

    public TestDataSource(String name, String contentType, String data) {
        this.setName(name).setContentType(contentType).setDataString(data);
    }

    public String getName() {
        return this._name;
    }

    public TestDataSource setName(String name) {
        this._name = name;
        return this;
    }

    public String getContentType() {
        return this._contentType;
    }

    public TestDataSource setContentType(String contentType) {
        this._contentType = contentType;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getData() {
        byte[] copy;
        this._dataLock.readLock().lock();
        try {
            copy = new byte[this._data.length];
            System.arraycopy(this._data, 0, copy, 0, this._data.length);
        }
        finally {
            this._dataLock.readLock().unlock();
        }
        return copy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TestDataSource setData(byte[] data) {
        if (data == null) {
            data = new byte[]{};
        }
        byte[] copy = new byte[data.length];
        System.arraycopy(data, 0, copy, 0, data.length);
        this._dataLock.writeLock().lock();
        try {
            this._data = copy;
        }
        finally {
            this._dataLock.writeLock().unlock();
        }
        return this;
    }

    public String getDataString() {
        return new String(this.getData(), UTF8);
    }

    public TestDataSource setDataString(String data) {
        this.setData(data != null ? data.getBytes(UTF8) : null);
        return this;
    }

    public InputStream getInputStream() throws IOException {
        return new ByteArrayInputStream(this.getData());
    }

    public OutputStream getOutputStream() throws IOException {
        return new ByteArrayOutputStream(){

            @Override
            public void flush() throws IOException {
                super.flush();
                TestDataSource.this.setData(this.toByteArray());
            }

            @Override
            public void close() throws IOException {
                super.close();
                TestDataSource.this.setData(this.toByteArray());
            }
        };
    }
}

