/*
 * Decompiled with CFR 0.152.
 */
package org.synchronoss.cloud.nio.stream.storage;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.synchronoss.cloud.nio.stream.storage.PurgeOnCloseFileInputStream;
import org.synchronoss.cloud.nio.stream.storage.StreamStorage;

public class DeferredFileStreamStorage
extends StreamStorage {
    private static final Logger log = LoggerFactory.getLogger(DeferredFileStreamStorage.class);
    static final int DEFAULT_THRESHOLD = 10240;
    final File file;
    final int threshold;
    final boolean purgeFileAfterReadComplete;
    volatile ReadWriteStatus readWriteStatus;
    volatile StorageMode storageMode;
    volatile ByteArrayOutputStream byteArrayOutputStream;
    volatile FileOutputStream fileOutputStream;

    public DeferredFileStreamStorage(File file, int threshold, boolean purgeFileAfterReadComplete) {
        this.file = file;
        this.threshold = threshold;
        this.purgeFileAfterReadComplete = purgeFileAfterReadComplete;
        this.readWriteStatus = ReadWriteStatus.WRITE;
        if (threshold <= 0) {
            this.storageMode = StorageMode.DISK;
            this.fileOutputStream = this.newFileOutputStream();
        } else {
            this.storageMode = StorageMode.MEMORY;
            this.byteArrayOutputStream = new ByteArrayOutputStream();
        }
    }

    public DeferredFileStreamStorage(File file, boolean purgeFileAfterReadComplete) {
        this(file, 10240, purgeFileAfterReadComplete);
    }

    public DeferredFileStreamStorage(File file, int threshold) {
        this(file, threshold, true);
    }

    public DeferredFileStreamStorage(File file) {
        this(file, 10240, true);
    }

    @Override
    public void write(int b) throws IOException {
        this.assertIsWritable();
        if (this.checkThreshold(1)) {
            this.byteArrayOutputStream.write(b);
        } else {
            this.fileOutputStream.write(b);
        }
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.assertIsWritable();
        if (this.checkThreshold(len)) {
            this.byteArrayOutputStream.write(b, off, len);
        } else {
            this.fileOutputStream.write(b, off, len);
        }
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.assertIsWritable();
        if (this.checkThreshold(b.length)) {
            this.byteArrayOutputStream.write(b);
        } else {
            this.fileOutputStream.write(b);
        }
    }

    @Override
    public void flush() throws IOException {
        this.assertIsWritable();
        if (this.fileOutputStream != null) {
            this.fileOutputStream.flush();
        }
    }

    @Override
    public void close() throws IOException {
        this.close(ReadWriteStatus.READ);
    }

    @Override
    public InputStream getInputStream() {
        if (this.readWriteStatus.equals((Object)ReadWriteStatus.READ)) {
            if (this.storageMode.equals((Object)StorageMode.MEMORY)) {
                return new ByteArrayInputStream(this.byteArrayOutputStream.toByteArray());
            }
            return this.newFileInputStream();
        }
        throw new IllegalStateException("The DeferredFileStreamStorage is still in write mode. Call the close() method when all the data has been written before asking for the InputStream.");
    }

    public boolean isInMemory() {
        return this.storageMode.equals((Object)StorageMode.MEMORY);
    }

    @Override
    public boolean dispose() {
        try {
            this.close(ReadWriteStatus.DISMISSED);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.file == null || !this.file.exists() || this.file.delete();
    }

    void close(ReadWriteStatus newReadWriteStatus) throws IOException {
        this.readWriteStatus = newReadWriteStatus;
        if (this.fileOutputStream != null) {
            this.fileOutputStream.close();
        }
    }

    boolean checkThreshold(int lengthToWrite) throws IOException {
        if (this.byteArrayOutputStream != null && this.byteArrayOutputStream.size() + lengthToWrite <= this.threshold) {
            return true;
        }
        if (this.isInMemory()) {
            this.switchToFile();
        }
        return false;
    }

    void assertIsWritable() {
        if (!this.readWriteStatus.equals((Object)ReadWriteStatus.WRITE)) {
            throw new IllegalStateException("OutputStream is closed");
        }
    }

    void switchToFile() throws IOException {
        if (log.isDebugEnabled()) {
            log.debug("Switching to file");
        }
        this.fileOutputStream = new FileOutputStream(this.file);
        this.fileOutputStream.write(this.byteArrayOutputStream.toByteArray());
        this.fileOutputStream.flush();
        this.byteArrayOutputStream.reset();
        this.byteArrayOutputStream = null;
        this.storageMode = StorageMode.DISK;
    }

    FileOutputStream newFileOutputStream() {
        try {
            return new FileOutputStream(this.file);
        }
        catch (Exception e) {
            throw new IllegalStateException("Unable to create the outputStream.", e);
        }
    }

    FileInputStream newFileInputStream() {
        try {
            if (this.purgeFileAfterReadComplete) {
                return new PurgeOnCloseFileInputStream(this.file);
            }
            return new FileInputStream(this.file);
        }
        catch (Exception e) {
            throw new IllegalStateException("Unable to create the inputStream.", e);
        }
    }

    static enum StorageMode {
        MEMORY,
        DISK;

    }

    static enum ReadWriteStatus {
        READ,
        WRITE,
        DISMISSED;

    }
}

