/*
 * Decompiled with CFR 0.152.
 */
package org.synchronoss.cloud.nio.stream.storage;

import java.io.File;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.synchronoss.cloud.nio.stream.storage.DeferredFileStreamStorage;
import org.synchronoss.cloud.nio.stream.storage.StreamStorage;
import org.synchronoss.cloud.nio.stream.storage.StreamStorageFactory;

public class DeferredFileStreamStorageFactory
implements StreamStorageFactory {
    private static final Logger log = LoggerFactory.getLogger(DeferredFileStreamStorageFactory.class);
    public static final int DEFAULT_MAX_THRESHOLD = 10240;
    public static final String DEFAULT_TEMP_FOLDER = System.getProperty("java.io.tmpdir") + "/nio-stream-storage";
    private final File _tempFolder;
    private final int _maxSizeThreshold;

    public DeferredFileStreamStorageFactory(String tempFolderPath, int maxSizeThreshold) {
        this._tempFolder = new File(tempFolderPath);
        if (!this._tempFolder.exists() && !this._tempFolder.mkdirs()) {
            throw new IllegalStateException("Unable to create the temporary folder: " + tempFolderPath);
        }
        int n = this._maxSizeThreshold = maxSizeThreshold > 0 ? maxSizeThreshold : 0;
        if (log.isDebugEnabled()) {
            log.debug("Temporary folder: " + this._tempFolder.getAbsolutePath());
        }
    }

    public DeferredFileStreamStorageFactory(String tempFolderPath) {
        this(tempFolderPath, 10240);
    }

    public DeferredFileStreamStorageFactory(int maxSizeThreshold) {
        this(DEFAULT_TEMP_FOLDER, maxSizeThreshold);
    }

    public DeferredFileStreamStorageFactory() {
        this(DEFAULT_TEMP_FOLDER, 10240);
    }

    @Override
    public StreamStorage create() {
        String tempFileName = String.format("stream-object-%s.tmp", UUID.randomUUID().toString());
        return new DeferredFileStreamStorage(new File(this._tempFolder, tempFileName), this._maxSizeThreshold, true);
    }
}

