/*
 * Decompiled with CFR 0.152.
 */
package org.synchronoss.cloud.nio.stream.storage;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PurgeOnCloseFileInputStream
extends FileInputStream {
    private static final Logger log = LoggerFactory.getLogger(PurgeOnCloseFileInputStream.class);
    private final File fileToPurge;

    public PurgeOnCloseFileInputStream(File file) throws FileNotFoundException {
        super(file);
        this.fileToPurge = file;
    }

    @Override
    public void close() throws IOException {
        super.close();
        if (this.fileToPurge.exists() && !this.fileToPurge.delete()) {
            log.warn("Failed to purge file: " + this.fileToPurge.getAbsolutePath());
        }
    }
}

