/*
 * Decompiled with CFR 0.152.
 */
package org.synchronoss.cloud.nio.stream.storage;

import java.io.File;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.synchronoss.cloud.nio.stream.storage.FileStreamStorage;
import org.synchronoss.cloud.nio.stream.storage.StreamStorage;
import org.synchronoss.cloud.nio.stream.storage.StreamStorageFactory;

public class DeferredFileStreamStorageFactory
implements StreamStorageFactory {
    private static final Logger log = LoggerFactory.getLogger(DeferredFileStreamStorageFactory.class);
    public static final int DEFAULT_MAX_THRESHOLD = 10240;
    public static final int DEFAULT_MAX_CAPACITY = -1;
    public static final String DEFAULT_ROOT_FOLDER = System.getProperty("java.io.tmpdir") + "/nio-stream-storage";
    private final File rootFolder;
    private final int maxSizeThreshold;
    private long maxCapacity = -1L;
    private boolean deleteFilesOnClose = false;
    private boolean deleteFilesOnDispose = false;

    public void setDeleteFilesOnClose(boolean deleteFilesOnClose) {
        this.deleteFilesOnClose = deleteFilesOnClose;
    }

    public void setDeleteFilesOnDispose(boolean deleteFilesOnDispose) {
        this.deleteFilesOnDispose = deleteFilesOnDispose;
    }

    public void setMaxCapacity(long maxCapacity) {
        this.maxCapacity = maxCapacity;
    }

    public DeferredFileStreamStorageFactory(String rootFolderPath, int maxSizeThreshold) {
        this.rootFolder = new File(rootFolderPath);
        if (!this.rootFolder.exists() && !this.rootFolder.mkdirs()) {
            throw new IllegalStateException("Unable to create the temporary folder: " + rootFolderPath);
        }
        int n = this.maxSizeThreshold = maxSizeThreshold > 0 ? maxSizeThreshold : 0;
        if (log.isDebugEnabled()) {
            log.debug("Root folder for data files: " + this.rootFolder.getAbsolutePath());
        }
    }

    public DeferredFileStreamStorageFactory(String tempFolderPath) {
        this(tempFolderPath, 10240);
    }

    public DeferredFileStreamStorageFactory(int maxSizeThreshold) {
        this(DEFAULT_ROOT_FOLDER, maxSizeThreshold);
    }

    public DeferredFileStreamStorageFactory() {
        this(DEFAULT_ROOT_FOLDER, 10240);
    }

    @Override
    public StreamStorage create() {
        return new FileStreamStorage(new File(this.rootFolder, this.getFileName()), this.maxSizeThreshold, this.deleteFilesOnClose, this.deleteFilesOnDispose, false, this.maxCapacity);
    }

    protected String getFileName() {
        return String.format("stream-object-%s.tmp", UUID.randomUUID().toString());
    }
}

