/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package tachyon;

/**
 * System wide constants
 */
public class Constants {
  public static final int KB = 1024;
  public static final int MB = KB * 1024;
  public static final int GB = MB * 1024;
  public static final long TB = GB * 1024L;

  public static final String ANSI_RESET = "\u001B[0m";
  public static final String ANSI_BLACK = "\u001B[30m";
  public static final String ANSI_RED = "\u001B[31m";
  public static final String ANSI_GREEN = "\u001B[32m";
  public static final String ANSI_YELLOW = "\u001B[33m";
  public static final String ANSI_BLUE = "\u001B[34m";
  public static final String ANSI_PURPLE = "\u001B[35m";
  public static final String ANSI_CYAN = "\u001B[36m";
  public static final String ANSI_WHITE = "\u001B[37m";

  public static final long SECOND_MS = 1000;
  public static final long MINUTE_MS = SECOND_MS * 60;
  public static final long HOUR_MS = MINUTE_MS * 60;
  public static final long DAY_MS = HOUR_MS * 24;

  public static final String HEADER = "tachyon://";
  public static final String HEADER_FT = "tachyon-ft://";

  public static final int DEFAULT_MASTER_PORT = 19998;
  public static final int DEFAULT_MASTER_WEB_PORT = DEFAULT_MASTER_PORT + 1;
  public static final int DEFAULT_WORKER_PORT = 29998;
  public static final int DEFAULT_WORKER_DATA_SERVER_PORT = DEFAULT_WORKER_PORT + 1;

  public static final int DEFAULT_BLOCK_SIZE_BYTE = 512 * MB;

  public static final String PATH_SEPARATOR = "/";
  public static final int MAX_COLUMNS = 1000;
  public static final int MAX_TABLE_METADATA_BYTE = MB * 5;
  public static final int WORKER_BLOCKS_QUEUE_SIZE = 10000;

  public static final String LOGGER_TYPE = System.getProperty("tachyon.logger.type", "");
  public static final boolean DEBUG = Boolean.valueOf(System.getProperty("tachyon.debug", "false"));

  public static final int JOURNAL_VERSION = 1; // The version keeps increasing.
}
