/*
 * Decompiled with CFR 0.152.
 */
package tachyon;

import org.apache.log4j.Logger;
import tachyon.Constants;
import tachyon.HeartbeatExecutor;

public class HeartbeatThread
extends Thread {
    private final Logger LOG = Logger.getLogger((String)Constants.LOGGER_TYPE);
    private final String THREAD_NAME;
    private final HeartbeatExecutor EXECUTOR;
    private final long FIXED_EXECUTION_INTERVAL_MS;
    private boolean mIsShutdown = false;

    public HeartbeatThread(String threadName, HeartbeatExecutor hbExecutor, long fixedExecutionIntervalMs) {
        this.THREAD_NAME = threadName;
        this.EXECUTOR = hbExecutor;
        this.FIXED_EXECUTION_INTERVAL_MS = fixedExecutionIntervalMs;
    }

    @Override
    public void run() {
        while (!this.mIsShutdown) {
            long lastMs = System.currentTimeMillis();
            this.EXECUTOR.heartbeat();
            try {
                long executionTimeMs = System.currentTimeMillis() - lastMs;
                if (executionTimeMs > this.FIXED_EXECUTION_INTERVAL_MS) {
                    this.LOG.error((Object)(this.THREAD_NAME + " last execution took " + executionTimeMs + " ms. Longer than " + " the FIXED_EXECUTION_INTERVAL_MS " + this.FIXED_EXECUTION_INTERVAL_MS));
                    continue;
                }
                Thread.sleep(this.FIXED_EXECUTION_INTERVAL_MS - executionTimeMs);
            }
            catch (InterruptedException e) {
                this.LOG.info((Object)e.getMessage(), (Throwable)e);
            }
        }
    }

    public void shutdown() {
        this.mIsShutdown = true;
    }
}

