/*
 * Decompiled with CFR 0.152.
 */
package tachyon.conf;

import org.apache.log4j.Logger;
import tachyon.util.CommonUtils;

class Utils {
    private static final Logger LOG = Logger.getLogger((String)"");

    Utils() {
    }

    public static String getProperty(String property) {
        String ret = System.getProperty(property);
        if (ret == null) {
            CommonUtils.illegalArgumentException(property + " is not configured.");
        } else {
            LOG.debug((Object)(property + " : " + ret));
        }
        return ret;
    }

    public static String getProperty(String property, String defaultValue) {
        String ret = System.getProperty(property);
        String msg = "";
        if (ret == null) {
            ret = defaultValue;
            msg = " uses the default value";
        }
        LOG.debug((Object)(property + msg + " : " + ret));
        return ret;
    }

    public static boolean getBooleanProperty(String property) {
        return Boolean.valueOf(Utils.getProperty(property));
    }

    public static boolean getBooleanProperty(String property, boolean defaultValue) {
        return Boolean.valueOf(Utils.getProperty(property, defaultValue + ""));
    }

    public static int getIntProperty(String property) {
        return Integer.valueOf(Utils.getProperty(property));
    }

    public static int getIntProperty(String property, int defaultValue) {
        return Integer.valueOf(Utils.getProperty(property, defaultValue + ""));
    }

    public static long getLongProperty(String property) {
        return Long.valueOf(Utils.getProperty(property));
    }

    public static long getLongProperty(String property, int defaultValue) {
        return Long.valueOf(Utils.getProperty(property, defaultValue + ""));
    }
}

