/*
 * Decompiled with CFR 0.152.
 */
package tachyon.examples;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import org.apache.log4j.Logger;
import tachyon.Constants;
import tachyon.Version;
import tachyon.client.OutStream;
import tachyon.client.TachyonByteBuffer;
import tachyon.client.TachyonFS;
import tachyon.client.TachyonFile;
import tachyon.client.WriteType;
import tachyon.examples.Utils;
import tachyon.master.DependencyType;
import tachyon.org.apache.thrift.TException;
import tachyon.util.CommonUtils;

public class BasicCheckpoint {
    private static Logger LOG = Logger.getLogger((String)Constants.LOGGER_TYPE);
    private static TachyonFS sTachyonClient;
    private static String sFileFolder;
    private static int sFiles;
    private static int sNumbers;
    private static boolean sPass;

    public static void createDependency() throws IOException {
        long startTimeMs = CommonUtils.getCurrentMs();
        ArrayList<String> children = new ArrayList<String>();
        for (int k = 0; k < sFiles; ++k) {
            children.add(sFileFolder + "/part-" + k);
        }
        ArrayList<ByteBuffer> data = new ArrayList<ByteBuffer>();
        data.add(ByteBuffer.allocate(10));
        int depId = sTachyonClient.createDependency(new ArrayList<String>(), children, "fake command", data, "BasicCheckpoint Dependency", "Tachyon Examples", "0.3", DependencyType.Narrow.getValue(), 0x20000000L);
        CommonUtils.printTimeTakenMs(startTimeMs, LOG, "createDependency with depId " + depId);
    }

    public static void writeFile() throws IOException {
        for (int i = 0; i < sFiles; ++i) {
            String filePath = sFileFolder + "/part-" + i;
            TachyonFile file = sTachyonClient.getFile(filePath);
            OutStream os = file.getOutStream(WriteType.ASYNC_THROUGH);
            ByteBuffer buf = ByteBuffer.allocate(80);
            buf.order(ByteOrder.nativeOrder());
            for (int k = 0; k < sNumbers; ++k) {
                buf.putInt(k);
            }
            buf.flip();
            LOG.debug((Object)("Writing data to " + filePath));
            ((OutputStream)os).write(buf.array());
            ((OutputStream)os).close();
        }
    }

    public static void readFile() throws IOException {
        for (int i = 0; i < sFiles; ++i) {
            String filePath = sFileFolder + "/part-" + i;
            LOG.debug((Object)("Reading data from " + filePath));
            TachyonFile file = sTachyonClient.getFile(filePath);
            TachyonByteBuffer buf = file.readByteBuffer();
            if (buf == null) {
                file.recache();
                buf = file.readByteBuffer();
            }
            buf.DATA.order(ByteOrder.nativeOrder());
            for (int k = 0; k < sNumbers; ++k) {
                sPass = sPass && buf.DATA.getInt() == k;
            }
            buf.close();
        }
    }

    public static void main(String[] args) throws IOException, TException {
        if (args.length != 3) {
            System.out.println("java -cp target/tachyon-" + Version.VERSION + "-jar-with-dependencies.jar " + "tachyon.examples.BasicCheckpoint <TachyonMasterAddress> <FileFolder> <Files>");
            System.exit(-1);
        }
        sTachyonClient = TachyonFS.get(args[0]);
        sFileFolder = args[1];
        sFiles = Integer.parseInt(args[2]);
        BasicCheckpoint.createDependency();
        BasicCheckpoint.writeFile();
        BasicCheckpoint.readFile();
        Utils.printPassInfo(sPass);
        System.exit(0);
    }

    static {
        sFileFolder = null;
        sNumbers = 20;
        sPass = true;
    }
}

