/*
 * Decompiled with CFR 0.152.
 */
package tachyon.master;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import tachyon.master.Inode;
import tachyon.master.InodeType;
import tachyon.thrift.ClientFileInfo;

public class InodeFolder
extends Inode {
    private Set<Integer> mChildren = new HashSet<Integer>();

    public InodeFolder(String name, int id, int parentId, long creationTimeMs) {
        this(name, id, parentId, InodeType.Folder, creationTimeMs);
    }

    public InodeFolder(String name, int id, int parentId, InodeType type, long creationTimeMs) {
        super(name, id, parentId, type, creationTimeMs);
    }

    public synchronized void addChild(int childId) {
        this.mChildren.add(childId);
    }

    public synchronized void addChildren(int[] childrenIds) {
        for (int k = 0; k < childrenIds.length; ++k) {
            this.addChild(childrenIds[k]);
        }
    }

    public synchronized Inode getChild(String name, Map<Integer, Inode> allInodes) {
        Inode tInode = null;
        for (int childId : this.mChildren) {
            tInode = allInodes.get(childId);
            if (tInode == null || !tInode.getName().equals(name)) continue;
            return tInode;
        }
        return null;
    }

    public synchronized List<Integer> getChildrenIds() {
        ArrayList<Integer> ret = new ArrayList<Integer>(this.mChildren.size());
        ret.addAll(this.mChildren);
        return ret;
    }

    public synchronized int getNumberOfChildren() {
        return this.mChildren.size();
    }

    public synchronized void removeChild(int id) {
        this.mChildren.remove(id);
    }

    public synchronized boolean removeChild(String name, Map<Integer, Inode> allInodes) {
        Inode tInode = null;
        for (int childId : this.mChildren) {
            tInode = allInodes.get(childId);
            if (tInode == null || !tInode.getName().equals(name)) continue;
            this.mChildren.remove(childId);
            return true;
        }
        return false;
    }

    public boolean isRawTable() {
        return this.TYPE == InodeType.RawTable;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("InodeFolder(");
        sb.append(super.toString()).append(",").append(this.mChildren).append(")");
        return sb.toString();
    }

    @Override
    public ClientFileInfo generateClientFileInfo(String path) {
        ClientFileInfo ret = new ClientFileInfo();
        ret.id = this.getId();
        ret.name = this.getName();
        ret.path = path;
        ret.checkpointPath = "";
        ret.length = 0L;
        ret.blockSizeByte = 0L;
        ret.creationTimeMs = this.getCreationTimeMs();
        ret.complete = true;
        ret.folder = true;
        ret.inMemory = true;
        ret.needPin = false;
        ret.needCache = false;
        ret.blockIds = null;
        ret.dependencyId = -1;
        return ret;
    }
}

