/*
 * Decompiled with CFR 0.152.
 */
package tachyon.worker;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import tachyon.org.apache.thrift.TException;
import tachyon.util.CommonUtils;
import tachyon.worker.WorkerStorage;

public class BlocksLocker {
    private Map<Long, Set<Integer>> mLockedBlockIds = new HashMap<Long, Set<Integer>>();
    private AtomicInteger mBlockLockId = new AtomicInteger(0);
    private int mUserId;
    private WorkerStorage mWorkerStorage;

    public BlocksLocker(WorkerStorage workerStorage, int userId) {
        this.mUserId = userId;
        this.mWorkerStorage = workerStorage;
    }

    public synchronized boolean locked(long blockId) {
        return this.mLockedBlockIds.containsKey(blockId);
    }

    public synchronized int lock(long blockId) {
        int locker = this.mBlockLockId.incrementAndGet();
        if (!this.mLockedBlockIds.containsKey(blockId)) {
            try {
                this.mWorkerStorage.lockBlock(blockId, this.mUserId);
            }
            catch (TException e) {
                CommonUtils.runtimeException(e);
            }
            this.mLockedBlockIds.put(blockId, new HashSet());
        }
        this.mLockedBlockIds.get(blockId).add(locker);
        return locker;
    }

    public synchronized void unlock(long blockId, int lockId) {
        Set<Integer> lockers = this.mLockedBlockIds.get(blockId);
        if (lockers != null) {
            lockers.remove(lockId);
            if (lockers.isEmpty()) {
                this.mLockedBlockIds.remove(blockId);
                try {
                    this.mWorkerStorage.unlockBlock(blockId, this.mUserId);
                }
                catch (TException e) {
                    CommonUtils.runtimeException(e);
                }
            }
        }
    }
}

