/*
 * Decompiled with CFR 0.152.
 */
package org.telegram.telegrambots.meta.api.methods.groupadministration;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.type.TypeReference;
import java.io.IOException;
import lombok.NonNull;
import org.telegram.telegrambots.meta.api.methods.BotApiMethod;
import org.telegram.telegrambots.meta.api.objects.ApiResponse;
import org.telegram.telegrambots.meta.exceptions.TelegramApiRequestException;
import org.telegram.telegrambots.meta.exceptions.TelegramApiValidationException;

public class PromoteChatMember
extends BotApiMethod<Boolean> {
    public static final String PATH = "promoteChatMember";
    private static final String CHATID_FIELD = "chat_id";
    private static final String USER_ID_FIELD = "user_id";
    private static final String CANCHANGEINFORMATION_FIELD = "can_change_info";
    private static final String CANPOSTMESSAGES_FIELD = "can_post_messages";
    private static final String CANEDITMESSAGES_FIELD = "can_edit_messages";
    private static final String CANDELETEMESSAGES_FIELD = "can_delete_messages";
    private static final String CANINVITEUSERS_FIELD = "can_invite_users";
    private static final String CANRESTRICTMEMBERS_FIELD = "can_restrict_members";
    private static final String CANPINMESSAGES_FIELD = "can_pin_messages";
    private static final String CANPROMOTEMEMBERS_FIELD = "can_promote_members";
    private static final String ISANONYMOUS_FIELD = "is_anonymous";
    private static final String CANMANAGECHAT_FIELD = "can_manage_chat";
    private static final String CANMANAGEVOICECHATS_FIELD = "can_manage_voice_chats";
    @JsonProperty(value="chat_id")
    @NonNull
    private String chatId;
    @JsonProperty(value="user_id")
    @NonNull
    private Long userId;
    @JsonProperty(value="can_change_info")
    private Boolean canChangeInformation;
    @JsonProperty(value="can_post_messages")
    private Boolean canPostMessages;
    @JsonProperty(value="can_edit_messages")
    private Boolean canEditMessages;
    @JsonProperty(value="can_delete_messages")
    private Boolean canDeleteMessages;
    @JsonProperty(value="can_invite_users")
    private Boolean canInviteUsers;
    @JsonProperty(value="can_restrict_members")
    private Boolean canRestrictMembers;
    @JsonProperty(value="can_pin_messages")
    private Boolean canPinMessages;
    @JsonProperty(value="can_promote_members")
    private Boolean canPromoteMembers;
    @JsonProperty(value="is_anonymous")
    private Boolean isAnonymous;
    @JsonProperty(value="can_manage_chat")
    private Boolean canManageChat;
    @JsonProperty(value="can_manage_voice_chats")
    private Boolean canManageVoiceChats;

    @Override
    public String getMethod() {
        return PATH;
    }

    @Override
    public Boolean deserializeResponse(String answer) throws TelegramApiRequestException {
        try {
            ApiResponse result = (ApiResponse)OBJECT_MAPPER.readValue(answer, (TypeReference)new TypeReference<ApiResponse<Boolean>>(){});
            if (result.getOk().booleanValue()) {
                return (Boolean)result.getResult();
            }
            throw new TelegramApiRequestException("Error promoting chat member", result);
        }
        catch (IOException e) {
            throw new TelegramApiRequestException("Unable to deserialize response", e);
        }
    }

    @Override
    public void validate() throws TelegramApiValidationException {
        if (this.chatId == null || this.chatId.isEmpty()) {
            throw new TelegramApiValidationException("ChatId can't be empty", this);
        }
        if (this.userId == null) {
            throw new TelegramApiValidationException("UserId can't be null", this);
        }
    }

    public static PromoteChatMemberBuilder builder() {
        return new PromoteChatMemberBuilder();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PromoteChatMember)) {
            return false;
        }
        PromoteChatMember other = (PromoteChatMember)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$userId = this.getUserId();
        Long other$userId = other.getUserId();
        if (this$userId == null ? other$userId != null : !((Object)this$userId).equals(other$userId)) {
            return false;
        }
        Boolean this$canChangeInformation = this.getCanChangeInformation();
        Boolean other$canChangeInformation = other.getCanChangeInformation();
        if (this$canChangeInformation == null ? other$canChangeInformation != null : !((Object)this$canChangeInformation).equals(other$canChangeInformation)) {
            return false;
        }
        Boolean this$canPostMessages = this.getCanPostMessages();
        Boolean other$canPostMessages = other.getCanPostMessages();
        if (this$canPostMessages == null ? other$canPostMessages != null : !((Object)this$canPostMessages).equals(other$canPostMessages)) {
            return false;
        }
        Boolean this$canEditMessages = this.getCanEditMessages();
        Boolean other$canEditMessages = other.getCanEditMessages();
        if (this$canEditMessages == null ? other$canEditMessages != null : !((Object)this$canEditMessages).equals(other$canEditMessages)) {
            return false;
        }
        Boolean this$canDeleteMessages = this.getCanDeleteMessages();
        Boolean other$canDeleteMessages = other.getCanDeleteMessages();
        if (this$canDeleteMessages == null ? other$canDeleteMessages != null : !((Object)this$canDeleteMessages).equals(other$canDeleteMessages)) {
            return false;
        }
        Boolean this$canInviteUsers = this.getCanInviteUsers();
        Boolean other$canInviteUsers = other.getCanInviteUsers();
        if (this$canInviteUsers == null ? other$canInviteUsers != null : !((Object)this$canInviteUsers).equals(other$canInviteUsers)) {
            return false;
        }
        Boolean this$canRestrictMembers = this.getCanRestrictMembers();
        Boolean other$canRestrictMembers = other.getCanRestrictMembers();
        if (this$canRestrictMembers == null ? other$canRestrictMembers != null : !((Object)this$canRestrictMembers).equals(other$canRestrictMembers)) {
            return false;
        }
        Boolean this$canPinMessages = this.getCanPinMessages();
        Boolean other$canPinMessages = other.getCanPinMessages();
        if (this$canPinMessages == null ? other$canPinMessages != null : !((Object)this$canPinMessages).equals(other$canPinMessages)) {
            return false;
        }
        Boolean this$canPromoteMembers = this.getCanPromoteMembers();
        Boolean other$canPromoteMembers = other.getCanPromoteMembers();
        if (this$canPromoteMembers == null ? other$canPromoteMembers != null : !((Object)this$canPromoteMembers).equals(other$canPromoteMembers)) {
            return false;
        }
        Boolean this$isAnonymous = this.getIsAnonymous();
        Boolean other$isAnonymous = other.getIsAnonymous();
        if (this$isAnonymous == null ? other$isAnonymous != null : !((Object)this$isAnonymous).equals(other$isAnonymous)) {
            return false;
        }
        Boolean this$canManageChat = this.getCanManageChat();
        Boolean other$canManageChat = other.getCanManageChat();
        if (this$canManageChat == null ? other$canManageChat != null : !((Object)this$canManageChat).equals(other$canManageChat)) {
            return false;
        }
        Boolean this$canManageVoiceChats = this.getCanManageVoiceChats();
        Boolean other$canManageVoiceChats = other.getCanManageVoiceChats();
        if (this$canManageVoiceChats == null ? other$canManageVoiceChats != null : !((Object)this$canManageVoiceChats).equals(other$canManageVoiceChats)) {
            return false;
        }
        String this$chatId = this.getChatId();
        String other$chatId = other.getChatId();
        return !(this$chatId == null ? other$chatId != null : !this$chatId.equals(other$chatId));
    }

    protected boolean canEqual(Object other) {
        return other instanceof PromoteChatMember;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $userId = this.getUserId();
        result = result * 59 + ($userId == null ? 43 : ((Object)$userId).hashCode());
        Boolean $canChangeInformation = this.getCanChangeInformation();
        result = result * 59 + ($canChangeInformation == null ? 43 : ((Object)$canChangeInformation).hashCode());
        Boolean $canPostMessages = this.getCanPostMessages();
        result = result * 59 + ($canPostMessages == null ? 43 : ((Object)$canPostMessages).hashCode());
        Boolean $canEditMessages = this.getCanEditMessages();
        result = result * 59 + ($canEditMessages == null ? 43 : ((Object)$canEditMessages).hashCode());
        Boolean $canDeleteMessages = this.getCanDeleteMessages();
        result = result * 59 + ($canDeleteMessages == null ? 43 : ((Object)$canDeleteMessages).hashCode());
        Boolean $canInviteUsers = this.getCanInviteUsers();
        result = result * 59 + ($canInviteUsers == null ? 43 : ((Object)$canInviteUsers).hashCode());
        Boolean $canRestrictMembers = this.getCanRestrictMembers();
        result = result * 59 + ($canRestrictMembers == null ? 43 : ((Object)$canRestrictMembers).hashCode());
        Boolean $canPinMessages = this.getCanPinMessages();
        result = result * 59 + ($canPinMessages == null ? 43 : ((Object)$canPinMessages).hashCode());
        Boolean $canPromoteMembers = this.getCanPromoteMembers();
        result = result * 59 + ($canPromoteMembers == null ? 43 : ((Object)$canPromoteMembers).hashCode());
        Boolean $isAnonymous = this.getIsAnonymous();
        result = result * 59 + ($isAnonymous == null ? 43 : ((Object)$isAnonymous).hashCode());
        Boolean $canManageChat = this.getCanManageChat();
        result = result * 59 + ($canManageChat == null ? 43 : ((Object)$canManageChat).hashCode());
        Boolean $canManageVoiceChats = this.getCanManageVoiceChats();
        result = result * 59 + ($canManageVoiceChats == null ? 43 : ((Object)$canManageVoiceChats).hashCode());
        String $chatId = this.getChatId();
        result = result * 59 + ($chatId == null ? 43 : $chatId.hashCode());
        return result;
    }

    @NonNull
    public String getChatId() {
        return this.chatId;
    }

    @NonNull
    public Long getUserId() {
        return this.userId;
    }

    public Boolean getCanChangeInformation() {
        return this.canChangeInformation;
    }

    public Boolean getCanPostMessages() {
        return this.canPostMessages;
    }

    public Boolean getCanEditMessages() {
        return this.canEditMessages;
    }

    public Boolean getCanDeleteMessages() {
        return this.canDeleteMessages;
    }

    public Boolean getCanInviteUsers() {
        return this.canInviteUsers;
    }

    public Boolean getCanRestrictMembers() {
        return this.canRestrictMembers;
    }

    public Boolean getCanPinMessages() {
        return this.canPinMessages;
    }

    public Boolean getCanPromoteMembers() {
        return this.canPromoteMembers;
    }

    public Boolean getIsAnonymous() {
        return this.isAnonymous;
    }

    public Boolean getCanManageChat() {
        return this.canManageChat;
    }

    public Boolean getCanManageVoiceChats() {
        return this.canManageVoiceChats;
    }

    @JsonProperty(value="chat_id")
    public void setChatId(@NonNull String chatId) {
        if (chatId == null) {
            throw new NullPointerException("chatId is marked non-null but is null");
        }
        this.chatId = chatId;
    }

    @JsonProperty(value="user_id")
    public void setUserId(@NonNull Long userId) {
        if (userId == null) {
            throw new NullPointerException("userId is marked non-null but is null");
        }
        this.userId = userId;
    }

    @JsonProperty(value="can_change_info")
    public void setCanChangeInformation(Boolean canChangeInformation) {
        this.canChangeInformation = canChangeInformation;
    }

    @JsonProperty(value="can_post_messages")
    public void setCanPostMessages(Boolean canPostMessages) {
        this.canPostMessages = canPostMessages;
    }

    @JsonProperty(value="can_edit_messages")
    public void setCanEditMessages(Boolean canEditMessages) {
        this.canEditMessages = canEditMessages;
    }

    @JsonProperty(value="can_delete_messages")
    public void setCanDeleteMessages(Boolean canDeleteMessages) {
        this.canDeleteMessages = canDeleteMessages;
    }

    @JsonProperty(value="can_invite_users")
    public void setCanInviteUsers(Boolean canInviteUsers) {
        this.canInviteUsers = canInviteUsers;
    }

    @JsonProperty(value="can_restrict_members")
    public void setCanRestrictMembers(Boolean canRestrictMembers) {
        this.canRestrictMembers = canRestrictMembers;
    }

    @JsonProperty(value="can_pin_messages")
    public void setCanPinMessages(Boolean canPinMessages) {
        this.canPinMessages = canPinMessages;
    }

    @JsonProperty(value="can_promote_members")
    public void setCanPromoteMembers(Boolean canPromoteMembers) {
        this.canPromoteMembers = canPromoteMembers;
    }

    @JsonProperty(value="is_anonymous")
    public void setIsAnonymous(Boolean isAnonymous) {
        this.isAnonymous = isAnonymous;
    }

    @JsonProperty(value="can_manage_chat")
    public void setCanManageChat(Boolean canManageChat) {
        this.canManageChat = canManageChat;
    }

    @JsonProperty(value="can_manage_voice_chats")
    public void setCanManageVoiceChats(Boolean canManageVoiceChats) {
        this.canManageVoiceChats = canManageVoiceChats;
    }

    public String toString() {
        return "PromoteChatMember(chatId=" + this.getChatId() + ", userId=" + this.getUserId() + ", canChangeInformation=" + this.getCanChangeInformation() + ", canPostMessages=" + this.getCanPostMessages() + ", canEditMessages=" + this.getCanEditMessages() + ", canDeleteMessages=" + this.getCanDeleteMessages() + ", canInviteUsers=" + this.getCanInviteUsers() + ", canRestrictMembers=" + this.getCanRestrictMembers() + ", canPinMessages=" + this.getCanPinMessages() + ", canPromoteMembers=" + this.getCanPromoteMembers() + ", isAnonymous=" + this.getIsAnonymous() + ", canManageChat=" + this.getCanManageChat() + ", canManageVoiceChats=" + this.getCanManageVoiceChats() + ")";
    }

    public PromoteChatMember(@NonNull String chatId, @NonNull Long userId) {
        if (chatId == null) {
            throw new NullPointerException("chatId is marked non-null but is null");
        }
        if (userId == null) {
            throw new NullPointerException("userId is marked non-null but is null");
        }
        this.chatId = chatId;
        this.userId = userId;
    }

    public PromoteChatMember() {
    }

    public PromoteChatMember(@NonNull String chatId, @NonNull Long userId, Boolean canChangeInformation, Boolean canPostMessages, Boolean canEditMessages, Boolean canDeleteMessages, Boolean canInviteUsers, Boolean canRestrictMembers, Boolean canPinMessages, Boolean canPromoteMembers, Boolean isAnonymous, Boolean canManageChat, Boolean canManageVoiceChats) {
        if (chatId == null) {
            throw new NullPointerException("chatId is marked non-null but is null");
        }
        if (userId == null) {
            throw new NullPointerException("userId is marked non-null but is null");
        }
        this.chatId = chatId;
        this.userId = userId;
        this.canChangeInformation = canChangeInformation;
        this.canPostMessages = canPostMessages;
        this.canEditMessages = canEditMessages;
        this.canDeleteMessages = canDeleteMessages;
        this.canInviteUsers = canInviteUsers;
        this.canRestrictMembers = canRestrictMembers;
        this.canPinMessages = canPinMessages;
        this.canPromoteMembers = canPromoteMembers;
        this.isAnonymous = isAnonymous;
        this.canManageChat = canManageChat;
        this.canManageVoiceChats = canManageVoiceChats;
    }

    public static class PromoteChatMemberBuilder {
        private String chatId;
        private Long userId;
        private Boolean canChangeInformation;
        private Boolean canPostMessages;
        private Boolean canEditMessages;
        private Boolean canDeleteMessages;
        private Boolean canInviteUsers;
        private Boolean canRestrictMembers;
        private Boolean canPinMessages;
        private Boolean canPromoteMembers;
        private Boolean isAnonymous;
        private Boolean canManageChat;
        private Boolean canManageVoiceChats;

        PromoteChatMemberBuilder() {
        }

        @JsonProperty(value="chat_id")
        public PromoteChatMemberBuilder chatId(@NonNull String chatId) {
            if (chatId == null) {
                throw new NullPointerException("chatId is marked non-null but is null");
            }
            this.chatId = chatId;
            return this;
        }

        @JsonProperty(value="user_id")
        public PromoteChatMemberBuilder userId(@NonNull Long userId) {
            if (userId == null) {
                throw new NullPointerException("userId is marked non-null but is null");
            }
            this.userId = userId;
            return this;
        }

        @JsonProperty(value="can_change_info")
        public PromoteChatMemberBuilder canChangeInformation(Boolean canChangeInformation) {
            this.canChangeInformation = canChangeInformation;
            return this;
        }

        @JsonProperty(value="can_post_messages")
        public PromoteChatMemberBuilder canPostMessages(Boolean canPostMessages) {
            this.canPostMessages = canPostMessages;
            return this;
        }

        @JsonProperty(value="can_edit_messages")
        public PromoteChatMemberBuilder canEditMessages(Boolean canEditMessages) {
            this.canEditMessages = canEditMessages;
            return this;
        }

        @JsonProperty(value="can_delete_messages")
        public PromoteChatMemberBuilder canDeleteMessages(Boolean canDeleteMessages) {
            this.canDeleteMessages = canDeleteMessages;
            return this;
        }

        @JsonProperty(value="can_invite_users")
        public PromoteChatMemberBuilder canInviteUsers(Boolean canInviteUsers) {
            this.canInviteUsers = canInviteUsers;
            return this;
        }

        @JsonProperty(value="can_restrict_members")
        public PromoteChatMemberBuilder canRestrictMembers(Boolean canRestrictMembers) {
            this.canRestrictMembers = canRestrictMembers;
            return this;
        }

        @JsonProperty(value="can_pin_messages")
        public PromoteChatMemberBuilder canPinMessages(Boolean canPinMessages) {
            this.canPinMessages = canPinMessages;
            return this;
        }

        @JsonProperty(value="can_promote_members")
        public PromoteChatMemberBuilder canPromoteMembers(Boolean canPromoteMembers) {
            this.canPromoteMembers = canPromoteMembers;
            return this;
        }

        @JsonProperty(value="is_anonymous")
        public PromoteChatMemberBuilder isAnonymous(Boolean isAnonymous) {
            this.isAnonymous = isAnonymous;
            return this;
        }

        @JsonProperty(value="can_manage_chat")
        public PromoteChatMemberBuilder canManageChat(Boolean canManageChat) {
            this.canManageChat = canManageChat;
            return this;
        }

        @JsonProperty(value="can_manage_voice_chats")
        public PromoteChatMemberBuilder canManageVoiceChats(Boolean canManageVoiceChats) {
            this.canManageVoiceChats = canManageVoiceChats;
            return this;
        }

        public PromoteChatMember build() {
            return new PromoteChatMember(this.chatId, this.userId, this.canChangeInformation, this.canPostMessages, this.canEditMessages, this.canDeleteMessages, this.canInviteUsers, this.canRestrictMembers, this.canPinMessages, this.canPromoteMembers, this.isAnonymous, this.canManageChat, this.canManageVoiceChats);
        }

        public String toString() {
            return "PromoteChatMember.PromoteChatMemberBuilder(chatId=" + this.chatId + ", userId=" + this.userId + ", canChangeInformation=" + this.canChangeInformation + ", canPostMessages=" + this.canPostMessages + ", canEditMessages=" + this.canEditMessages + ", canDeleteMessages=" + this.canDeleteMessages + ", canInviteUsers=" + this.canInviteUsers + ", canRestrictMembers=" + this.canRestrictMembers + ", canPinMessages=" + this.canPinMessages + ", canPromoteMembers=" + this.canPromoteMembers + ", isAnonymous=" + this.isAnonymous + ", canManageChat=" + this.canManageChat + ", canManageVoiceChats=" + this.canManageVoiceChats + ")";
        }
    }
}

