/*
 * Decompiled with CFR 0.152.
 */
package org.telegram.telegrambots.meta.api.methods.groupadministration;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.type.TypeReference;
import java.io.IOException;
import lombok.NonNull;
import org.telegram.telegrambots.meta.api.methods.BotApiMethod;
import org.telegram.telegrambots.meta.api.objects.ApiResponse;
import org.telegram.telegrambots.meta.exceptions.TelegramApiRequestException;
import org.telegram.telegrambots.meta.exceptions.TelegramApiValidationException;

public class UnbanChatMember
extends BotApiMethod<Boolean> {
    public static final String PATH = "unbanchatmember";
    private static final String CHATID_FIELD = "chat_id";
    private static final String USERID_FIELD = "user_id";
    private static final String ONLYISBANNED_FIELD = "only_if_banned";
    @JsonProperty(value="chat_id")
    @NonNull
    private String chatId;
    @JsonProperty(value="user_id")
    @NonNull
    private Long userId;
    @JsonProperty(value="only_if_banned")
    private Boolean onlyIfBanned;

    @Override
    public String getMethod() {
        return PATH;
    }

    @Override
    public Boolean deserializeResponse(String answer) throws TelegramApiRequestException {
        try {
            ApiResponse result = (ApiResponse)OBJECT_MAPPER.readValue(answer, (TypeReference)new TypeReference<ApiResponse<Boolean>>(){});
            if (result.getOk().booleanValue()) {
                return (Boolean)result.getResult();
            }
            throw new TelegramApiRequestException("Error unbanning chat member", result);
        }
        catch (IOException e) {
            throw new TelegramApiRequestException("Unable to deserialize response", e);
        }
    }

    @Override
    public void validate() throws TelegramApiValidationException {
        if (this.chatId == null || this.chatId.isEmpty()) {
            throw new TelegramApiValidationException("ChatId can't be empty", this);
        }
        if (this.userId == null) {
            throw new TelegramApiValidationException("UserId can't be null", this);
        }
    }

    public static UnbanChatMemberBuilder builder() {
        return new UnbanChatMemberBuilder();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof UnbanChatMember)) {
            return false;
        }
        UnbanChatMember other = (UnbanChatMember)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$userId = this.getUserId();
        Long other$userId = other.getUserId();
        if (this$userId == null ? other$userId != null : !((Object)this$userId).equals(other$userId)) {
            return false;
        }
        Boolean this$onlyIfBanned = this.getOnlyIfBanned();
        Boolean other$onlyIfBanned = other.getOnlyIfBanned();
        if (this$onlyIfBanned == null ? other$onlyIfBanned != null : !((Object)this$onlyIfBanned).equals(other$onlyIfBanned)) {
            return false;
        }
        String this$chatId = this.getChatId();
        String other$chatId = other.getChatId();
        return !(this$chatId == null ? other$chatId != null : !this$chatId.equals(other$chatId));
    }

    protected boolean canEqual(Object other) {
        return other instanceof UnbanChatMember;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $userId = this.getUserId();
        result = result * 59 + ($userId == null ? 43 : ((Object)$userId).hashCode());
        Boolean $onlyIfBanned = this.getOnlyIfBanned();
        result = result * 59 + ($onlyIfBanned == null ? 43 : ((Object)$onlyIfBanned).hashCode());
        String $chatId = this.getChatId();
        result = result * 59 + ($chatId == null ? 43 : $chatId.hashCode());
        return result;
    }

    @NonNull
    public String getChatId() {
        return this.chatId;
    }

    @NonNull
    public Long getUserId() {
        return this.userId;
    }

    public Boolean getOnlyIfBanned() {
        return this.onlyIfBanned;
    }

    @JsonProperty(value="chat_id")
    public void setChatId(@NonNull String chatId) {
        if (chatId == null) {
            throw new NullPointerException("chatId is marked non-null but is null");
        }
        this.chatId = chatId;
    }

    @JsonProperty(value="user_id")
    public void setUserId(@NonNull Long userId) {
        if (userId == null) {
            throw new NullPointerException("userId is marked non-null but is null");
        }
        this.userId = userId;
    }

    @JsonProperty(value="only_if_banned")
    public void setOnlyIfBanned(Boolean onlyIfBanned) {
        this.onlyIfBanned = onlyIfBanned;
    }

    public String toString() {
        return "UnbanChatMember(chatId=" + this.getChatId() + ", userId=" + this.getUserId() + ", onlyIfBanned=" + this.getOnlyIfBanned() + ")";
    }

    public UnbanChatMember(@NonNull String chatId, @NonNull Long userId) {
        if (chatId == null) {
            throw new NullPointerException("chatId is marked non-null but is null");
        }
        if (userId == null) {
            throw new NullPointerException("userId is marked non-null but is null");
        }
        this.chatId = chatId;
        this.userId = userId;
    }

    public UnbanChatMember() {
    }

    public UnbanChatMember(@NonNull String chatId, @NonNull Long userId, Boolean onlyIfBanned) {
        if (chatId == null) {
            throw new NullPointerException("chatId is marked non-null but is null");
        }
        if (userId == null) {
            throw new NullPointerException("userId is marked non-null but is null");
        }
        this.chatId = chatId;
        this.userId = userId;
        this.onlyIfBanned = onlyIfBanned;
    }

    public static class UnbanChatMemberBuilder {
        private String chatId;
        private Long userId;
        private Boolean onlyIfBanned;

        UnbanChatMemberBuilder() {
        }

        @JsonProperty(value="chat_id")
        public UnbanChatMemberBuilder chatId(@NonNull String chatId) {
            if (chatId == null) {
                throw new NullPointerException("chatId is marked non-null but is null");
            }
            this.chatId = chatId;
            return this;
        }

        @JsonProperty(value="user_id")
        public UnbanChatMemberBuilder userId(@NonNull Long userId) {
            if (userId == null) {
                throw new NullPointerException("userId is marked non-null but is null");
            }
            this.userId = userId;
            return this;
        }

        @JsonProperty(value="only_if_banned")
        public UnbanChatMemberBuilder onlyIfBanned(Boolean onlyIfBanned) {
            this.onlyIfBanned = onlyIfBanned;
            return this;
        }

        public UnbanChatMember build() {
            return new UnbanChatMember(this.chatId, this.userId, this.onlyIfBanned);
        }

        public String toString() {
            return "UnbanChatMember.UnbanChatMemberBuilder(chatId=" + this.chatId + ", userId=" + this.userId + ", onlyIfBanned=" + this.onlyIfBanned + ")";
        }
    }
}

