/*
 * Decompiled with CFR 0.152.
 */
package org.telegram.telegrambots.meta.api.methods.groupadministration;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.type.TypeReference;
import java.io.IOException;
import lombok.NonNull;
import org.telegram.telegrambots.meta.api.methods.BotApiMethod;
import org.telegram.telegrambots.meta.api.objects.ApiResponse;
import org.telegram.telegrambots.meta.exceptions.TelegramApiRequestException;
import org.telegram.telegrambots.meta.exceptions.TelegramApiValidationException;

public class unbanChatSenderChat
extends BotApiMethod<Boolean> {
    public static final String PATH = "unbanChatSenderChat";
    private static final String CHATID_FIELD = "chat_id";
    private static final String SENDER_CHAT_ID_FIELD = "sender_chat_id";
    @JsonProperty(value="chat_id")
    @NonNull
    private String chatId;
    @JsonProperty(value="sender_chat_id")
    @NonNull
    private Long senderChatId;

    @Override
    public String getMethod() {
        return PATH;
    }

    @Override
    public Boolean deserializeResponse(String answer) throws TelegramApiRequestException {
        try {
            ApiResponse result = (ApiResponse)OBJECT_MAPPER.readValue(answer, (TypeReference)new TypeReference<ApiResponse<Boolean>>(){});
            if (result.getOk().booleanValue()) {
                return (Boolean)result.getResult();
            }
            throw new TelegramApiRequestException("Error unbanning chat sender", result);
        }
        catch (IOException e) {
            throw new TelegramApiRequestException("Unable to deserialize response", e);
        }
    }

    @Override
    public void validate() throws TelegramApiValidationException {
        if (this.chatId.isEmpty()) {
            throw new TelegramApiValidationException("ChatId can't be empty", this);
        }
        if (this.senderChatId == 0L) {
            throw new TelegramApiValidationException("SenderChatId can't be null or 0", this);
        }
    }

    public static unbanChatSenderChatBuilder builder() {
        return new unbanChatSenderChatBuilder();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof unbanChatSenderChat)) {
            return false;
        }
        unbanChatSenderChat other = (unbanChatSenderChat)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$senderChatId = this.getSenderChatId();
        Long other$senderChatId = other.getSenderChatId();
        if (this$senderChatId == null ? other$senderChatId != null : !((Object)this$senderChatId).equals(other$senderChatId)) {
            return false;
        }
        String this$chatId = this.getChatId();
        String other$chatId = other.getChatId();
        return !(this$chatId == null ? other$chatId != null : !this$chatId.equals(other$chatId));
    }

    protected boolean canEqual(Object other) {
        return other instanceof unbanChatSenderChat;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $senderChatId = this.getSenderChatId();
        result = result * 59 + ($senderChatId == null ? 43 : ((Object)$senderChatId).hashCode());
        String $chatId = this.getChatId();
        result = result * 59 + ($chatId == null ? 43 : $chatId.hashCode());
        return result;
    }

    @NonNull
    public String getChatId() {
        return this.chatId;
    }

    @NonNull
    public Long getSenderChatId() {
        return this.senderChatId;
    }

    @JsonProperty(value="chat_id")
    public void setChatId(@NonNull String chatId) {
        if (chatId == null) {
            throw new NullPointerException("chatId is marked non-null but is null");
        }
        this.chatId = chatId;
    }

    @JsonProperty(value="sender_chat_id")
    public void setSenderChatId(@NonNull Long senderChatId) {
        if (senderChatId == null) {
            throw new NullPointerException("senderChatId is marked non-null but is null");
        }
        this.senderChatId = senderChatId;
    }

    public String toString() {
        return "unbanChatSenderChat(chatId=" + this.getChatId() + ", senderChatId=" + this.getSenderChatId() + ")";
    }

    public unbanChatSenderChat() {
    }

    public unbanChatSenderChat(@NonNull String chatId, @NonNull Long senderChatId) {
        if (chatId == null) {
            throw new NullPointerException("chatId is marked non-null but is null");
        }
        if (senderChatId == null) {
            throw new NullPointerException("senderChatId is marked non-null but is null");
        }
        this.chatId = chatId;
        this.senderChatId = senderChatId;
    }

    public static class unbanChatSenderChatBuilder {
        private String chatId;
        private Long senderChatId;

        unbanChatSenderChatBuilder() {
        }

        @JsonProperty(value="chat_id")
        public unbanChatSenderChatBuilder chatId(@NonNull String chatId) {
            if (chatId == null) {
                throw new NullPointerException("chatId is marked non-null but is null");
            }
            this.chatId = chatId;
            return this;
        }

        @JsonProperty(value="sender_chat_id")
        public unbanChatSenderChatBuilder senderChatId(@NonNull Long senderChatId) {
            if (senderChatId == null) {
                throw new NullPointerException("senderChatId is marked non-null but is null");
            }
            this.senderChatId = senderChatId;
            return this;
        }

        public unbanChatSenderChat build() {
            return new unbanChatSenderChat(this.chatId, this.senderChatId);
        }

        public String toString() {
            return "unbanChatSenderChat.unbanChatSenderChatBuilder(chatId=" + this.chatId + ", senderChatId=" + this.senderChatId + ")";
        }
    }
}

