/*
 * Decompiled with CFR 0.152.
 */
package org.telegram.telegrambots.meta.api.objects.commands.scope;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import lombok.NonNull;
import org.telegram.telegrambots.meta.api.objects.commands.scope.BotCommandScope;
import org.telegram.telegrambots.meta.exceptions.TelegramApiValidationException;

@JsonDeserialize
public class BotCommandScopeChat
implements BotCommandScope {
    private static final String TYPE_FIELD = "type";
    private static final String CHATID_FIELD = "chat_id";
    @JsonProperty(value="type")
    private final String type = "chat";
    @JsonProperty(value="chat_id")
    @NonNull
    private String chatId;

    @Override
    public void validate() throws TelegramApiValidationException {
        if (this.chatId == null || this.chatId.isEmpty()) {
            throw new TelegramApiValidationException("ChatId parameter can't be empty", this);
        }
    }

    public static BotCommandScopeChatBuilder builder() {
        return new BotCommandScopeChatBuilder();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BotCommandScopeChat)) {
            return false;
        }
        BotCommandScopeChat other = (BotCommandScopeChat)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$type = this.getType();
        String other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        String this$chatId = this.getChatId();
        String other$chatId = other.getChatId();
        return !(this$chatId == null ? other$chatId != null : !this$chatId.equals(other$chatId));
    }

    protected boolean canEqual(Object other) {
        return other instanceof BotCommandScopeChat;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        String $chatId = this.getChatId();
        result = result * 59 + ($chatId == null ? 43 : $chatId.hashCode());
        return result;
    }

    @Override
    public String getType() {
        return this.type;
    }

    @NonNull
    public String getChatId() {
        return this.chatId;
    }

    @JsonProperty(value="chat_id")
    public void setChatId(@NonNull String chatId) {
        if (chatId == null) {
            throw new NullPointerException("chatId is marked non-null but is null");
        }
        this.chatId = chatId;
    }

    public String toString() {
        return "BotCommandScopeChat(type=" + this.getType() + ", chatId=" + this.getChatId() + ")";
    }

    public BotCommandScopeChat() {
    }

    public BotCommandScopeChat(@NonNull String chatId) {
        if (chatId == null) {
            throw new NullPointerException("chatId is marked non-null but is null");
        }
        this.chatId = chatId;
    }

    public static class BotCommandScopeChatBuilder {
        private String chatId;

        BotCommandScopeChatBuilder() {
        }

        @JsonProperty(value="chat_id")
        public BotCommandScopeChatBuilder chatId(@NonNull String chatId) {
            if (chatId == null) {
                throw new NullPointerException("chatId is marked non-null but is null");
            }
            this.chatId = chatId;
            return this;
        }

        public BotCommandScopeChat build() {
            return new BotCommandScopeChat(this.chatId);
        }

        public String toString() {
            return "BotCommandScopeChat.BotCommandScopeChatBuilder(chatId=" + this.chatId + ")";
        }
    }
}

