/*
 * Decompiled with CFR 0.152.
 */
package com.sun.glass.ui.monocle;

import com.sun.glass.ui.Pixels;
import com.sun.glass.ui.Robot;
import com.sun.glass.ui.monocle.MonoclePixels;
import com.sun.glass.ui.monocle.NativePlatformFactory;
import com.sun.glass.ui.monocle.NativeScreen;
import com.sun.glass.ui.monocle.input.KeyInput;
import com.sun.glass.ui.monocle.input.KeyState;
import com.sun.glass.ui.monocle.input.MouseInput;
import com.sun.glass.ui.monocle.input.MouseState;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.nio.ShortBuffer;
import javafx.application.Platform;

public class MonocleRobot
extends Robot {
    protected void _create() {
    }

    protected void _destroy() {
    }

    protected void _keyPress(int code) {
        Platform.runLater(() -> {
            KeyState state = new KeyState();
            KeyInput.getInstance().getState(state);
            state.pressKey(code);
            KeyInput.getInstance().setState(state);
        });
    }

    protected void _keyRelease(int code) {
        Platform.runLater(() -> {
            KeyState state = new KeyState();
            KeyInput.getInstance().getState(state);
            state.releaseKey(code);
            KeyInput.getInstance().setState(state);
        });
    }

    protected void _mouseMove(int x, int y) {
        Platform.runLater(() -> {
            MouseState state = new MouseState();
            MouseInput.getInstance().getState(state);
            state.setX(x);
            state.setY(y);
            MouseInput.getInstance().setState(state, false);
        });
    }

    protected void _mousePress(int buttons) {
        Platform.runLater(() -> {
            MouseState state = new MouseState();
            MouseInput.getInstance().getState(state);
            if ((buttons & 1) != 0) {
                state.pressButton(212);
            }
            if ((buttons & 4) != 0) {
                state.pressButton(214);
            }
            if ((buttons & 2) != 0) {
                state.pressButton(213);
            }
            MouseInput.getInstance().setState(state, false);
        });
    }

    protected void _mouseRelease(int buttons) {
        Platform.runLater(() -> {
            MouseState state = new MouseState();
            MouseInput.getInstance().getState(state);
            if ((buttons & 1) != 0) {
                state.releaseButton(212);
            }
            if ((buttons & 4) != 0) {
                state.releaseButton(214);
            }
            if ((buttons & 2) != 0) {
                state.releaseButton(213);
            }
            MouseInput.getInstance().setState(state, false);
        });
    }

    protected void _mouseWheel(int wheelAmt) {
        Platform.runLater(() -> {
            MouseState state = new MouseState();
            MouseInput mouse = MouseInput.getInstance();
            mouse.getState(state);
            int direction = wheelAmt < 0 ? -1 : 1;
            for (int i = 0; i < Math.abs(wheelAmt); ++i) {
                state.setWheel(direction);
                mouse.setState(state, false);
                state.setWheel(0);
                mouse.setState(state, false);
            }
        });
    }

    protected int _getMouseX() {
        MouseState state = new MouseState();
        MouseInput.getInstance().getState(state);
        return state.getX();
    }

    protected int _getMouseY() {
        MouseState state = new MouseState();
        MouseInput.getInstance().getState(state);
        return state.getY();
    }

    protected int _getPixelColor(int x, int y) {
        NativeScreen screen = NativePlatformFactory.getNativePlatform().getScreen();
        int byteDepth = screen.getDepth() >>> 3;
        int bwidth = screen.getWidth();
        int bheight = screen.getHeight();
        if (x < 0 || x > bwidth || y < 0 || y > bheight) {
            return 0;
        }
        Object object = NativeScreen.framebufferSwapLock;
        synchronized (object) {
            ByteBuffer buffer = screen.getScreenCapture();
            if (byteDepth == 2) {
                ShortBuffer shortbuf = buffer.asShortBuffer();
                short v = shortbuf.get(y * bwidth + x);
                int red = (v & 0xF800) >> 11 << 3;
                int green = (v & 0x7E0) >> 5 << 2;
                int blue = (v & 0x1F) << 3;
                int p = 0xFF000000 | red << 16 | green << 8 | blue;
                return p;
            }
            if (byteDepth >= 4) {
                IntBuffer intbuf = buffer.asIntBuffer();
                return intbuf.get(y * bwidth + x);
            }
            throw new RuntimeException("Unknown bit depth");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Pixels _getScreenCapture(int x, int y, int width, int height, boolean isHiDPI) {
        NativeScreen screen = NativePlatformFactory.getNativePlatform().getScreen();
        int byteDepth = screen.getDepth() >>> 3;
        int bwidth = screen.getWidth();
        int bheight = screen.getHeight();
        IntBuffer ret = null;
        Object object = NativeScreen.framebufferSwapLock;
        synchronized (object) {
            ByteBuffer buffer = screen.getScreenCapture();
            if (x == 0 && y == 0 && width == screen.getWidth() && height == screen.getHeight() && byteDepth == 4) {
                return new MonoclePixels(width, height, buffer.asIntBuffer());
            }
            int size = width * height;
            ret = IntBuffer.allocate(size);
            ShortBuffer shortbuf = null;
            IntBuffer intbuf = null;
            if (byteDepth == 2) {
                shortbuf = buffer.asShortBuffer();
            } else if (byteDepth >= 4) {
                intbuf = buffer.asIntBuffer();
            } else {
                throw new RuntimeException("Unknown bit depth");
            }
            for (int row = y; row < y + height; ++row) {
                int col;
                int bufferRowStart = row * bwidth;
                int retRowStart = (row - y) * width;
                ret.position(retRowStart);
                if (row < 0 || row >= bheight) {
                    for (col = 0; col < width; ++col) {
                        ret.put(-16777216);
                    }
                    continue;
                }
                for (col = x; col < 0; ++col) {
                    ret.put(-16777216);
                }
                while (col < x + width && col < bwidth) {
                    if (byteDepth == 4) {
                        ret.put(intbuf.get(bufferRowStart + col));
                    } else if (byteDepth == 2) {
                        short v = shortbuf.get(bufferRowStart + col);
                        int red = (v & 0xF800) >> 11 << 3;
                        int green = (v & 0x7E0) >> 5 << 2;
                        int blue = (v & 0x1F) << 3;
                        int p = 0xFF000000 | red << 16 | green << 8 | blue;
                        ret.put(p);
                    }
                    ++col;
                }
                while (col < x + width) {
                    ret.put(-16777216);
                    ++col;
                }
            }
            ret.clear();
            return new MonoclePixels(width, height, ret);
        }
    }
}

