/*
 * Decompiled with CFR 0.152.
 */
package com.sun.glass.ui.monocle;

import com.sun.glass.ui.monocle.MonocleSettings;
import com.sun.glass.ui.monocle.MonocleTrace;
import com.sun.glass.ui.monocle.NativePlatform;
import java.security.AccessController;
import java.util.Locale;

public abstract class NativePlatformFactory {
    private static NativePlatform platform;

    protected abstract boolean matches();

    protected abstract NativePlatform createNativePlatform();

    public static synchronized NativePlatform getNativePlatform() {
        if (platform == null) {
            String platformFactoryProperty = AccessController.doPrivileged(() -> System.getProperty("monocle.platform", "MX6,OMAP,Dispman,X11,Linux,Headless"));
            String[] platformFactories = platformFactoryProperty.split(",");
            for (int i = 0; i < platformFactories.length; ++i) {
                String factoryName = platformFactories[i].trim();
                String factoryClassName = factoryName.contains(".") ? factoryName : "com.sun.glass.ui.monocle." + factoryName.toLowerCase(Locale.ROOT) + "." + factoryName + "PlatformFactory";
                if (MonocleSettings.settings.tracePlatformConfig) {
                    MonocleTrace.traceConfig("Trying platform %s with class %s", factoryName, factoryClassName);
                }
                try {
                    NativePlatformFactory npf = (NativePlatformFactory)Class.forName(factoryClassName).newInstance();
                    if (!npf.matches()) continue;
                    platform = npf.createNativePlatform();
                    if (MonocleSettings.settings.tracePlatformConfig) {
                        MonocleTrace.traceConfig("Matched %s", factoryName);
                    }
                    return platform;
                }
                catch (Exception e) {
                    if (MonocleSettings.settings.tracePlatformConfig) {
                        MonocleTrace.traceConfig("Failed to create platform %s", factoryClassName);
                    }
                    e.printStackTrace();
                }
            }
            throw new UnsupportedOperationException("Cannot load a native platform from: '" + platformFactoryProperty + "'");
        }
        return platform;
    }
}

