/*
 * Decompiled with CFR 0.152.
 */
package com.sun.glass.ui.monocle.input;

import com.sun.glass.ui.monocle.MonocleWindow;
import com.sun.glass.ui.monocle.MonocleWindowManager;
import com.sun.glass.ui.monocle.util.IntSet;

public class KeyState {
    private IntSet keysPressed = new IntSet();
    private MonocleWindow window;
    private int modifiers;

    public void clear() {
        this.keysPressed.clear();
        this.modifiers = 0;
    }

    public void pressKey(int virtualKeyCode) {
        this.keysPressed.addInt(virtualKeyCode);
        this.modifiers |= KeyState.getModifier(virtualKeyCode);
    }

    public void releaseKey(int virtualKeyCode) {
        this.keysPressed.removeInt(virtualKeyCode);
        this.modifiers &= ~KeyState.getModifier(virtualKeyCode);
    }

    public void copyTo(KeyState target) {
        this.keysPressed.copyTo(target.keysPressed);
        target.window = this.window;
        target.modifiers = this.modifiers;
    }

    public IntSet getKeysPressed() {
        return this.keysPressed;
    }

    MonocleWindow getWindow(boolean recalculateCache) {
        if (this.window == null || recalculateCache) {
            this.window = MonocleWindowManager.getInstance().getFocusedWindow();
        }
        return this.window;
    }

    private static int getModifier(int virtualKeyCode) {
        switch (virtualKeyCode) {
            case 16: {
                return 1;
            }
            case 17: {
                return 4;
            }
            case 18: {
                return 8;
            }
            case 768: {
                return 16;
            }
            case 524: {
                return 16;
            }
        }
        return 0;
    }

    public int getModifiers() {
        return this.modifiers;
    }

    public boolean isShiftPressed() {
        return (this.modifiers & 1) != 0;
    }

    public boolean isControlPressed() {
        return (this.modifiers & 4) != 0;
    }

    public String toString() {
        return "KeyState[modifiers=" + this.modifiers + ",keys=" + this.keysPressed + "]";
    }
}

