/*
 * Decompiled with CFR 0.152.
 */
package com.sun.glass.ui.monocle.input.filters;

import com.sun.glass.ui.monocle.input.TouchInput;
import com.sun.glass.ui.monocle.input.TouchState;
import com.sun.glass.ui.monocle.input.filters.TouchFilter;

public final class NearbyPointsTouchFilter
implements TouchFilter {
    private final int radius = TouchInput.getInstance().getTouchRadius();

    @Override
    public int getPriority() {
        return 100;
    }

    @Override
    public boolean filter(TouchState state) {
        while (this.mergeClosestPoints(state)) {
        }
        return false;
    }

    private boolean mergeClosestPoints(TouchState state) {
        int pointIndex1 = -1;
        int pointIndex2 = -1;
        int closestDistanceSquared = Integer.MAX_VALUE;
        for (int i = 0; i < state.getPointCount(); ++i) {
            for (int j = i + 1; j < state.getPointCount(); ++j) {
                TouchState.Point p1 = state.getPoint(i);
                TouchState.Point p2 = state.getPoint(j);
                int dx = p1.x - p2.x;
                int dy = p1.y - p2.y;
                int distanceSquared = dx * dx + dy * dy;
                if (distanceSquared >= closestDistanceSquared) continue;
                closestDistanceSquared = distanceSquared;
                pointIndex1 = i;
                pointIndex2 = j;
            }
        }
        if (closestDistanceSquared < this.radius * this.radius) {
            TouchState.Point p1 = state.getPoint(pointIndex1);
            TouchState.Point p2 = state.getPoint(pointIndex2);
            p1.x = (p1.x + p2.x) / 2;
            p1.y = (p1.y + p2.y) / 2;
            state.removePointForID(p2.id);
            return true;
        }
        return false;
    }

    @Override
    public boolean flush(TouchState state) {
        return false;
    }

    public boolean equals(Object o) {
        return o instanceof NearbyPointsTouchFilter;
    }

    public int hashCode() {
        return 0;
    }

    public String toString() {
        return "NearbyPoints";
    }
}

