/*
 * Decompiled with CFR 0.152.
 */
package com.sun.glass.ui.monocle.linux;

import com.sun.glass.ui.monocle.linux.LinuxSystem;
import java.io.File;
import java.io.IOException;
import java.util.BitSet;
import java.util.HashMap;
import java.util.Map;

public class AbsoluteInputCapabilities {
    private int value;
    private int minimum;
    private int maximum;
    private int fuzz;
    private int flat;
    private int resolution;

    public AbsoluteInputCapabilities(int value, int maximum, int minimum, int fuzz, int flat, int resolution) {
        this.value = value;
        this.maximum = maximum;
        this.minimum = minimum;
        this.fuzz = fuzz;
        this.flat = flat;
        this.resolution = resolution;
    }

    private AbsoluteInputCapabilities(LinuxSystem system, LinuxSystem.InputAbsInfo info, long fd, int axis) throws IOException {
        system.ioctl(fd, system.EVIOCGABS(axis), info.p);
        this.value = LinuxSystem.InputAbsInfo.getValue(info.p);
        this.minimum = LinuxSystem.InputAbsInfo.getMinimum(info.p);
        this.maximum = LinuxSystem.InputAbsInfo.getMaximum(info.p);
        this.fuzz = LinuxSystem.InputAbsInfo.getFuzz(info.p);
        this.flat = LinuxSystem.InputAbsInfo.getFlat(info.p);
        this.resolution = LinuxSystem.InputAbsInfo.getResolution(info.p);
    }

    static Map<Integer, AbsoluteInputCapabilities> getCapabilities(File devNode, BitSet axes) throws IOException {
        if (axes == null || axes.isEmpty()) {
            return null;
        }
        LinuxSystem system = LinuxSystem.getLinuxSystem();
        LinuxSystem.InputAbsInfo info = new LinuxSystem.InputAbsInfo();
        long fd = system.open(devNode.getPath(), 0);
        if (fd == -1L) {
            throw new IOException(system.getErrorMessage());
        }
        HashMap<Integer, AbsoluteInputCapabilities> caps = new HashMap<Integer, AbsoluteInputCapabilities>();
        int i = 0;
        while ((i = axes.nextSetBit(i)) != -1) {
            caps.put(i, new AbsoluteInputCapabilities(system, info, fd, i));
            ++i;
        }
        system.close(fd);
        return caps;
    }

    public int getValue() {
        return this.value;
    }

    public int getMinimum() {
        return this.minimum;
    }

    public int getMaximum() {
        return this.maximum;
    }

    public int getFuzz() {
        return this.fuzz;
    }

    public int getFlat() {
        return this.flat;
    }

    public int getResolution() {
        return this.resolution;
    }
}

