/*
 * Decompiled with CFR 0.152.
 */
package com.sun.glass.ui.monocle.linux;

import com.sun.glass.ui.monocle.MonocleSettings;
import com.sun.glass.ui.monocle.MonocleTrace;
import com.sun.glass.ui.monocle.linux.Input;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public class LinuxEventBuffer {
    static final int EVENT_STRUCT_SIZE = 16;
    private static final int EVENT_STRUCT_TYPE_INDEX = 8;
    private static final int EVENT_STRUCT_CODE_INDEX = 10;
    private static final int EVENT_STRUCT_VALUE_INDEX = 12;
    private static final int EVENT_BUFFER_SIZE = 1000;
    private final ByteBuffer bb = ByteBuffer.allocate(16000);
    private int positionOfLastSync;
    private int currentPosition;
    private int mark;

    LinuxEventBuffer() {
        this.bb.order(ByteOrder.nativeOrder());
    }

    public synchronized boolean put(ByteBuffer event) throws InterruptedException {
        boolean isSync;
        boolean bl = isSync = event.getInt(8) == 0 && event.getInt(12) == 0;
        while (this.bb.limit() - this.bb.position() < event.limit()) {
            if (MonocleSettings.settings.traceEventsVerbose) {
                MonocleTrace.traceEvent("Event buffer %s is full, waiting for some space to become available", this.bb);
            }
            this.wait();
        }
        if (isSync) {
            this.positionOfLastSync = this.bb.position();
        }
        this.bb.put(event);
        if (MonocleSettings.settings.traceEventsVerbose) {
            int index = this.bb.position() - 16;
            MonocleTrace.traceEvent("Read %s [index=%d]", this.getEventDescription(index), index);
        }
        return isSync;
    }

    public synchronized void startIteration() {
        this.currentPosition = 0;
        this.mark = 0;
        if (MonocleSettings.settings.traceEventsVerbose) {
            MonocleTrace.traceEvent("Processing %s [index=%d]", this.getEventDescription(), this.currentPosition);
        }
    }

    public synchronized void compact() {
        this.positionOfLastSync -= this.currentPosition;
        int newLimit = this.bb.position();
        this.bb.position(this.currentPosition);
        this.bb.limit(newLimit);
        this.bb.compact();
        if (MonocleSettings.settings.traceEventsVerbose) {
            MonocleTrace.traceEvent("Compacted event buffer %s", this.bb);
        }
        this.notifyAll();
    }

    public synchronized short getEventType() {
        return this.bb.getShort(this.currentPosition + 8);
    }

    public short getEventCode() {
        return this.bb.getShort(this.currentPosition + 10);
    }

    public synchronized int getEventValue() {
        return this.bb.getInt(this.currentPosition + 12);
    }

    public synchronized String getEventDescription() {
        return this.getEventDescription(this.currentPosition);
    }

    private synchronized String getEventDescription(int position) {
        short type = this.bb.getShort(position + 8);
        short code = this.bb.getShort(position + 10);
        int value = this.bb.getInt(position + 12);
        String typeStr = Input.typeToString(type);
        return typeStr + " " + Input.codeToString(typeStr, code) + " " + value;
    }

    public synchronized void nextEvent() {
        if (this.currentPosition > this.positionOfLastSync) {
            throw new IllegalStateException("Cannot advance past the last EV_SYN EV_SYN_REPORT 0");
        }
        this.currentPosition += 16;
        if (MonocleSettings.settings.traceEventsVerbose && this.hasNextEvent()) {
            MonocleTrace.traceEvent("Processing %s [index=%d]", this.getEventDescription(), this.currentPosition);
        }
    }

    public synchronized void mark() {
        this.mark = this.currentPosition;
    }

    public synchronized void reset() {
        this.currentPosition = this.mark;
    }

    public synchronized boolean hasNextEvent() {
        return this.currentPosition <= this.positionOfLastSync;
    }

    synchronized boolean hasData() {
        return this.bb.position() != 0;
    }
}

