/*
 * Decompiled with CFR 0.152.
 */
package com.sun.glass.ui.monocle.linux;

import com.sun.glass.ui.monocle.input.InputDeviceRegistry;
import com.sun.glass.ui.monocle.linux.LinuxInputDevice;
import com.sun.glass.ui.monocle.linux.LinuxInputProcessor;
import com.sun.glass.ui.monocle.linux.LinuxKeyProcessor;
import com.sun.glass.ui.monocle.linux.LinuxMouseProcessor;
import com.sun.glass.ui.monocle.linux.LinuxSimpleTouchProcessor;
import com.sun.glass.ui.monocle.linux.LinuxStatefulMultiTouchProcessor;
import com.sun.glass.ui.monocle.linux.LinuxStatelessMultiTouchProcessor;
import com.sun.glass.ui.monocle.linux.SysFS;
import com.sun.glass.ui.monocle.linux.Udev;
import com.sun.glass.ui.monocle.linux.UdevListener;
import java.io.File;
import java.io.IOException;
import java.security.AllPermission;
import java.util.BitSet;
import java.util.HashMap;
import java.util.Map;

public class LinuxInputDeviceRegistry
extends InputDeviceRegistry {
    public LinuxInputDeviceRegistry(boolean headless) {
        if (headless) {
            return;
        }
        HashMap deviceMap = new HashMap();
        UdevListener udevListener = (action, event) -> {
            String subsystem = (String)event.get("SUBSYSTEM");
            String devPath = (String)event.get("DEVPATH");
            String devName = (String)event.get("DEVNAME");
            if (subsystem != null && subsystem.equals("input") && devPath != null && devName != null) {
                try {
                    File sysPath = new File("/sys", devPath);
                    if (action.equals("add") || action.equals("change") && !deviceMap.containsKey(sysPath)) {
                        File devNode = new File(devName);
                        LinuxInputDevice device = this.createDevice(devNode, sysPath, event);
                        if (device != null) {
                            deviceMap.put(sysPath, device);
                        }
                    } else if (action.equals("remove")) {
                        LinuxInputDevice device = (LinuxInputDevice)deviceMap.get(sysPath);
                        deviceMap.remove(sysPath);
                        if (device != null) {
                            this.devices.remove((Object)device);
                        }
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        };
        Udev.getInstance().addListener(udevListener);
        SysFS.triggerUdevNotification("input");
    }

    private LinuxInputDevice createDevice(File devNode, File sysPath, Map<String, String> udevManifest) throws IOException {
        LinuxInputDevice device = new LinuxInputDevice(devNode, sysPath, udevManifest);
        return this.addDeviceInternal(device, "Linux input: " + devNode.toString());
    }

    public LinuxInputDevice addDevice(LinuxInputDevice device, String name) {
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            security.checkPermission(new AllPermission());
        }
        return this.addDeviceInternal(device, name);
    }

    private LinuxInputDevice addDeviceInternal(LinuxInputDevice device, String name) {
        LinuxInputProcessor processor = this.createInputProcessor(device);
        if (processor == null) {
            return null;
        }
        device.setInputProcessor(this.createInputProcessor(device));
        Thread thread = new Thread(device);
        thread.setName(name);
        thread.setDaemon(true);
        thread.start();
        this.devices.add((Object)device);
        return device;
    }

    public void removeDevice(LinuxInputDevice device) {
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            security.checkPermission(new AllPermission());
        }
        this.devices.remove((Object)device);
    }

    private LinuxInputProcessor createInputProcessor(LinuxInputDevice device) {
        if (device.isTouch()) {
            boolean isMT;
            BitSet absCaps = device.getCapability("abs");
            boolean bl = isMT = absCaps.get(53) && absCaps.get(54);
            if (isMT) {
                if (absCaps.get(57)) {
                    return new LinuxStatefulMultiTouchProcessor(device);
                }
                return new LinuxStatelessMultiTouchProcessor(device);
            }
            return new LinuxSimpleTouchProcessor(device);
        }
        if (device.isRelative()) {
            return new LinuxMouseProcessor();
        }
        BitSet keyCaps = device.getCapability("key");
        if (keyCaps != null && !keyCaps.isEmpty()) {
            return new LinuxKeyProcessor();
        }
        return null;
    }
}

