/*
 * Decompiled with CFR 0.152.
 */
package com.sun.glass.ui.monocle.linux;

import com.sun.glass.ui.monocle.input.MouseInput;
import com.sun.glass.ui.monocle.input.MouseState;
import com.sun.glass.ui.monocle.linux.LinuxEventBuffer;
import com.sun.glass.ui.monocle.linux.LinuxInputDevice;
import com.sun.glass.ui.monocle.linux.LinuxInputProcessor;

public class LinuxMouseProcessor
implements LinuxInputProcessor {
    private MouseInput mouse = MouseInput.getInstance();
    private MouseState previousState = new MouseState();
    private MouseState state = new MouseState();
    private boolean hasPendingState;

    @Override
    public void processEvents(LinuxInputDevice device) {
        LinuxEventBuffer buffer = device.getBuffer();
        this.mouse.getState(this.previousState);
        this.mouse.getState(this.state);
        this.hasPendingState = false;
        while (buffer.hasNextEvent()) {
            block0 : switch (buffer.getEventType()) {
                case 2: {
                    switch (buffer.getEventCode()) {
                        case 0: {
                            int x = this.previousState.getX();
                            this.state.setX(x += buffer.getEventValue());
                            break block0;
                        }
                        case 1: {
                            int y = this.previousState.getY();
                            this.state.setY(y += buffer.getEventValue());
                            break block0;
                        }
                        case 8: {
                            int value = buffer.getEventValue();
                            if (value < 0) {
                                this.state.setWheel(-1);
                                break block0;
                            }
                            if (value > 0) {
                                this.state.setWheel(1);
                                break block0;
                            }
                            this.state.setWheel(0);
                            break block0;
                        }
                    }
                    break;
                }
                case 0: {
                    switch (buffer.getEventCode()) {
                        case 0: {
                            this.sendEvent();
                            break block0;
                        }
                    }
                    break;
                }
                case 1: {
                    int button = LinuxMouseProcessor.mouseButtonForKeyCode(buffer.getEventCode());
                    if (button < 0) break;
                    if (buffer.getEventValue() == 0) {
                        this.state.releaseButton(button);
                        break;
                    }
                    this.state.pressButton(button);
                    break;
                }
            }
            buffer.nextEvent();
        }
        if (this.hasPendingState) {
            this.mouse.setState(this.previousState, false);
        }
    }

    private void sendEvent() {
        if (this.state.canBeFoldedWith(this.previousState)) {
            this.hasPendingState = true;
        } else {
            if (this.hasPendingState) {
                this.mouse.setState(this.previousState, false);
                this.hasPendingState = false;
            }
            this.mouse.setState(this.state, false);
        }
        this.state.copyTo(this.previousState);
    }

    private static int mouseButtonForKeyCode(int keyCode) {
        switch (keyCode) {
            case 272: {
                return 212;
            }
            case 274: {
                return 214;
            }
            case 273: {
                return 213;
            }
        }
        return -1;
    }
}

