/*
 * Decompiled with CFR 0.152.
 */
package com.sun.glass.ui.monocle.linux;

import com.sun.glass.ui.monocle.util.C;
import com.sun.glass.utils.NativeLibLoader;
import java.nio.ByteBuffer;
import java.security.Permission;

public class LinuxSystem {
    private static Permission permission = new RuntimePermission("loadLibrary.*");
    private static LinuxSystem instance = new LinuxSystem();
    public static final int O_RDONLY = 0;
    public static final int O_WRONLY = 1;
    public static final int O_RDWR = 2;
    public static final int O_NONBLOCK = 2048;
    public static final int SEEK_SET = 0;
    public static final int FBIOGET_VSCREENINFO = 17920;
    public static final int FBIOPUT_VSCREENINFO = 17921;
    public static final int FBIOPAN_DISPLAY = 17926;
    public static final int FBIOBLANK = 17937;
    public static final int FB_BLANK_UNBLANK = 0;
    public static final int FB_ACTIVATE_NOW = 0;
    public static final int FB_ACTIVATE_VBL = 16;
    private static int __SID = 21248;
    public static int I_FLUSH = __SID | 5;
    public static int FLUSHRW = 3;
    public static final int ENXIO = 6;
    public static final int EAGAIN = 11;
    public static final int RTLD_LAZY = 1;
    public static final int RTLD_GLOBAL = 256;
    public static final long PROT_READ = 1L;
    public static final long PROT_WRITE = 2L;
    public static final long MAP_PRIVATE = 2L;
    public static final long MAP_ANONYMOUS = 32L;
    public static final long MAP_SHARED = 1L;
    public static final long MAP_FAILED = 0xFFFFFFFFL;
    public static int S_IRWXU = 448;

    public static LinuxSystem getLinuxSystem() {
        LinuxSystem.checkPermissions();
        return instance;
    }

    private static void checkPermissions() {
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            security.checkPermission(permission);
        }
    }

    private LinuxSystem() {
    }

    public void loadLibrary() {
        NativeLibLoader.loadLibrary((String)"glass_monocle");
    }

    public native void setenv(String var1, String var2, boolean var3);

    public native long open(String var1, int var2);

    public native int close(long var1);

    public native long lseek(long var1, long var3, int var5);

    public native long write(long var1, ByteBuffer var3, int var4, int var5);

    public native long read(long var1, ByteBuffer var3, int var4, int var5);

    native int EVIOCGABS(int var1);

    public native int ioctl(long var1, int var3, long var4);

    public native int IOW(int var1, int var2, int var3);

    public native int IOR(int var1, int var2, int var3);

    public native int IOWR(int var1, int var2, int var3);

    public native int errno();

    public native String strerror(int var1);

    public native long dlopen(String var1, int var2);

    public native String dlerror();

    public native long dlsym(long var1, String var3);

    public native int dlclose(long var1);

    public native long mmap(long var1, long var3, long var5, long var7, long var9, long var11);

    public native int munmap(long var1, long var3);

    public native long memcpy(long var1, long var3, long var5);

    public String getErrorMessage() {
        return this.strerror(this.errno());
    }

    public native int mkfifo(String var1, int var2);

    public static class FbVarScreenInfo
    extends C.Structure {
        public FbVarScreenInfo() {
            LinuxSystem.checkPermissions();
        }

        @Override
        public native int sizeof();

        public native int getBitsPerPixel(long var1);

        public native int getXRes(long var1);

        public native int getYRes(long var1);

        public native int getXResVirtual(long var1);

        public native int getYResVirtual(long var1);

        public native int getOffsetX(long var1);

        public native int getOffsetY(long var1);

        public native void setRes(long var1, int var3, int var4);

        public native void setVirtualRes(long var1, int var3, int var4);

        public native void setOffset(long var1, int var3, int var4);

        public native void setActivate(long var1, int var3);

        public native void setBitsPerPixel(long var1, int var3);

        public native void setRed(long var1, int var3, int var4);

        public native void setGreen(long var1, int var3, int var4);

        public native void setBlue(long var1, int var3, int var4);

        public native void setTransp(long var1, int var3, int var4);
    }

    static class InputAbsInfo
    extends C.Structure {
        InputAbsInfo() {
        }

        @Override
        public native int sizeof();

        static native int getValue(long var0);

        static native int getMinimum(long var0);

        static native int getMaximum(long var0);

        static native int getFuzz(long var0);

        static native int getFlat(long var0);

        static native int getResolution(long var0);
    }
}

