/*
 * Decompiled with CFR 0.152.
 */
package com.sun.glass.ui.monocle.linux;

import com.sun.glass.ui.monocle.NativePlatformFactory;
import com.sun.glass.ui.monocle.RunnableProcessor;
import com.sun.glass.ui.monocle.linux.UdevListener;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

public class Udev
implements Runnable {
    private static Udev instance;
    private long fd = this._open();
    private ByteBuffer buffer = ByteBuffer.allocateDirect(4096);
    private Thread thread;
    private UdevListener[] listeners;

    public static synchronized Udev getInstance() {
        if (instance == null) {
            try {
                instance = new Udev();
            }
            catch (IOException e) {
                System.err.println("Udev: failed to open connection");
                e.printStackTrace();
            }
        }
        return instance;
    }

    private Udev() throws IOException {
        this.buffer.order(ByteOrder.nativeOrder());
        this.thread = new Thread((Runnable)this, "udev monitor");
        this.thread.setDaemon(true);
        this.thread.start();
    }

    public synchronized void addListener(UdevListener listener) {
        if (this.listeners == null) {
            this.listeners = new UdevListener[]{listener};
        } else {
            this.listeners = Arrays.copyOf(this.listeners, this.listeners.length + 1);
            this.listeners[this.listeners.length - 1] = listener;
        }
    }

    private native long _open() throws IOException;

    private native int _readEvent(long var1, ByteBuffer var3) throws IOException;

    private native void _close(long var1);

    private native int _getPropertiesOffset(ByteBuffer var1);

    private native int _getPropertiesLength(ByteBuffer var1);

    @Override
    public void run() {
        try {
            RunnableProcessor runnableProcessor = NativePlatformFactory.getNativePlatform().getRunnableProcessor();
            while (true) {
                final Map<String, String> event = this.readEvent();
                runnableProcessor.invokeLater(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        String action = (String)event.get("ACTION");
                        if (action != null) {
                            UdevListener[] uls;
                            1 var3_2 = this;
                            synchronized (var3_2) {
                                uls = Udev.this.listeners;
                            }
                            if (uls != null) {
                                for (int i = 0; i < uls.length; ++i) {
                                    try {
                                        uls[i].udevEvent(action, event);
                                        continue;
                                    }
                                    catch (RuntimeException e) {
                                        System.err.println("Exception in udev listener:");
                                        e.printStackTrace();
                                        continue;
                                    }
                                    catch (Error e) {
                                        System.err.println("Error in udev listener, closing udev");
                                        e.printStackTrace();
                                        Udev.this.close();
                                        return;
                                    }
                                }
                            }
                        }
                    }
                });
            }
        }
        catch (IOException e) {
            if (!this.thread.isInterrupted()) {
                System.err.println("Exception in udev thread:");
                e.printStackTrace();
                this.close();
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, String> readEvent() throws IOException {
        ByteBuffer b;
        HashMap<String, String> map = new HashMap<String, String>();
        Udev udev = this;
        synchronized (udev) {
            b = this.buffer;
            if (b == null) {
                return map;
            }
        }
        int length = this._readEvent(this.fd, b);
        Udev udev2 = this;
        synchronized (udev2) {
            int propertiesLength;
            if (this.buffer == null) {
                return map;
            }
            int propertiesOffset = this._getPropertiesOffset(this.buffer);
            int propertiesEnd = propertiesOffset + (propertiesLength = this._getPropertiesLength(this.buffer));
            if (length < propertiesEnd) {
                throw new IOException("Mismatched property segment length");
            }
            this.buffer.position(propertiesOffset);
            StringBuffer key = new StringBuffer();
            StringBuffer value = new StringBuffer();
            block13: while (this.buffer.position() < propertiesEnd) {
                char ch;
                key.setLength(0);
                value.setLength(0);
                boolean readKey = false;
                block14: while (this.buffer.position() < length && !readKey) {
                    ch = (char)this.buffer.get();
                    switch (ch) {
                        case '\u0000': {
                            map.put(key.toString(), "");
                            continue block13;
                        }
                        case '=': {
                            readKey = true;
                            continue block14;
                        }
                    }
                    key.append(ch);
                }
                while (this.buffer.position() < propertiesEnd) {
                    ch = (char)this.buffer.get();
                    switch (ch) {
                        case '\u0000': {
                            map.put(key.toString(), value.toString());
                            continue block13;
                        }
                    }
                    value.append(ch);
                }
            }
            this.buffer.clear();
        }
        return map;
    }

    public synchronized void close() {
        this.thread.interrupt();
        this._close(this.fd);
        this.fd = 0L;
        this.buffer = null;
        this.thread = null;
    }
}

