/*
 * Decompiled with CFR 0.152.
 */
package com.sun.glass.ui.monocle.mx6;

import com.sun.glass.ui.Size;
import com.sun.glass.ui.monocle.NativeCursor;
import com.sun.glass.ui.monocle.NativeCursors;
import com.sun.glass.ui.monocle.NativePlatformFactory;
import com.sun.glass.ui.monocle.linux.LinuxSystem;
import com.sun.glass.ui.monocle.linux.SysFS;
import com.sun.glass.ui.monocle.util.C;
import java.io.IOException;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.IntBuffer;
import java.nio.ShortBuffer;

public class MX6Cursor
extends NativeCursor {
    private int hotspotX;
    private int hotspotY;
    private int offsetX;
    private int offsetY;
    private int cursorX;
    private int cursorY;
    private static final int SHORT_KEY = 43947;
    private static final int CURSOR_WIDTH = 16;
    private static final int CURSOR_HEIGHT = 16;
    private Buffer cursorBuffer;
    private Buffer offsetCursorBuffer;
    private ByteBuffer offsetCursorByteBuffer;
    private int screenWidth;
    private int screenHeight;
    private LinuxSystem system;
    private MXCFBPos pos = new MXCFBPos();
    private MXCFBGblAlpha alpha = new MXCFBGblAlpha();
    private long fd = -1L;

    public MX6Cursor() {
        Object screen;
        try {
            SysFS.write("/sys/class/graphics/fb1/blank", "0");
            this.system = LinuxSystem.getLinuxSystem();
            screen = new LinuxSystem.FbVarScreenInfo();
            this.fd = this.system.open("/dev/fb1", 2);
            if (this.fd == -1L) {
                throw new IOException(this.system.getErrorMessage());
            }
            this.system.ioctl(this.fd, 17920, ((LinuxSystem.FbVarScreenInfo)screen).p);
            ((LinuxSystem.FbVarScreenInfo)screen).setRes(((LinuxSystem.FbVarScreenInfo)screen).p, 16, 16);
            ((LinuxSystem.FbVarScreenInfo)screen).setVirtualRes(((LinuxSystem.FbVarScreenInfo)screen).p, 16, 16);
            ((LinuxSystem.FbVarScreenInfo)screen).setOffset(((LinuxSystem.FbVarScreenInfo)screen).p, 0, 0);
            ((LinuxSystem.FbVarScreenInfo)screen).setActivate(((LinuxSystem.FbVarScreenInfo)screen).p, 0);
            ((LinuxSystem.FbVarScreenInfo)screen).setBitsPerPixel(((LinuxSystem.FbVarScreenInfo)screen).p, 16);
            ((LinuxSystem.FbVarScreenInfo)screen).setRed(((LinuxSystem.FbVarScreenInfo)screen).p, 5, 11);
            ((LinuxSystem.FbVarScreenInfo)screen).setGreen(((LinuxSystem.FbVarScreenInfo)screen).p, 6, 5);
            ((LinuxSystem.FbVarScreenInfo)screen).setBlue(((LinuxSystem.FbVarScreenInfo)screen).p, 5, 0);
            ((LinuxSystem.FbVarScreenInfo)screen).setTransp(((LinuxSystem.FbVarScreenInfo)screen).p, 0, 0);
            this.system.ioctl(this.fd, 17921, ((LinuxSystem.FbVarScreenInfo)screen).p);
            this.system.ioctl(this.fd, 17937, 0L);
            MXCFBColorKey key = new MXCFBColorKey();
            key.setEnable(1);
            key.setColorKey(11367770);
            int MXCFB_SET_CLR_KEY = this.system.IOW(70, 34, key.sizeof());
            if (this.system.ioctl(this.fd, MXCFB_SET_CLR_KEY, key.p) < 0) {
                throw new IOException(this.system.strerror(this.system.errno()));
            }
        }
        catch (IOException e) {
            if (this.fd != -1L) {
                LinuxSystem.getLinuxSystem().close(this.fd);
                this.fd = -1L;
            }
            e.printStackTrace();
            System.err.println("Failed to initialize i.MX6 cursor");
        }
        screen = NativePlatformFactory.getNativePlatform().getScreen();
        this.screenWidth = screen.getWidth();
        this.screenHeight = screen.getHeight();
    }

    @Override
    public Size getBestSize() {
        return new Size(16, 16);
    }

    @Override
    public void setVisibility(boolean visibility) {
        this.alpha.setEnable(1);
        this.alpha.setAlpha(visibility ? 255 : 0);
        int MXCFB_SET_GBL_ALPHA = this.system.IOW(70, 33, this.alpha.sizeof());
        this.system.ioctl(this.fd, MXCFB_SET_GBL_ALPHA, this.alpha.p);
        this.isVisible = visibility;
        this.updateImage(true);
    }

    private void updateImage(boolean always) {
        if (this.isVisible && this.cursorBuffer != null) {
            int newOffsetX = Math.max(0, 16 + this.cursorX - this.screenWidth);
            int newOffsetY = Math.max(0, 16 + this.cursorY - this.screenHeight);
            if (newOffsetX != this.offsetX || newOffsetY != this.offsetY || always) {
                NativeCursors.offsetCursor(this.cursorBuffer, this.offsetCursorBuffer, newOffsetX, newOffsetY, 16, 16, 16, 43947);
                this.offsetX = newOffsetX;
                this.offsetY = newOffsetY;
                this.system.lseek(this.fd, 0L, 0);
                if (this.system.write(this.fd, this.offsetCursorByteBuffer, 0, this.offsetCursorByteBuffer.capacity()) < 0L) {
                    System.err.println("Failed to write to i.MX6 cursor: " + this.system.getErrorMessage());
                }
            }
        }
    }

    @Override
    public void setImage(byte[] cursorImage) {
        ByteBuffer bb = ByteBuffer.allocate(cursorImage.length);
        this.cursorBuffer = bb.asShortBuffer();
        NativeCursors.colorKeyCursor(cursorImage, this.cursorBuffer, 16, 43947);
        this.offsetCursorByteBuffer = ByteBuffer.allocateDirect(cursorImage.length);
        this.offsetCursorByteBuffer.order(ByteOrder.nativeOrder());
        this.offsetCursorBuffer = this.offsetCursorByteBuffer.asShortBuffer();
        this.updateImage(true);
    }

    @Override
    public void setLocation(int x, int y) {
        this.cursorX = x;
        this.cursorY = y;
        this.updateImage(false);
        this.pos.set(x, y);
        int MXCFB_SET_OVERLAY_POS = this.system.IOWR(70, 36, this.pos.sizeof());
        this.system.ioctl(this.fd, MXCFB_SET_OVERLAY_POS, this.pos.p);
    }

    @Override
    public void setHotSpot(int hotspotX, int hotspotY) {
        this.hotspotX = hotspotX;
        this.hotspotY = hotspotY;
    }

    @Override
    public void shutdown() {
        this.setVisibility(false);
    }

    private static class MXCFBPos
    extends C.Structure {
        private final ShortBuffer data;

        MXCFBPos() {
            this.b.order(ByteOrder.nativeOrder());
            this.data = this.b.asShortBuffer();
        }

        @Override
        public int sizeof() {
            return 4;
        }

        void set(int x, int y) {
            this.data.put(0, (short)x);
            this.data.put(1, (short)y);
        }
    }

    private static class MXCFBGblAlpha
    extends C.Structure {
        private final IntBuffer data;

        MXCFBGblAlpha() {
            this.b.order(ByteOrder.nativeOrder());
            this.data = this.b.asIntBuffer();
        }

        @Override
        public int sizeof() {
            return 8;
        }

        void setEnable(int enable) {
            this.data.put(0, enable);
        }

        void setAlpha(int alpha) {
            this.data.put(1, alpha);
        }
    }

    private static class MXCFBColorKey
    extends C.Structure {
        private final IntBuffer data;

        MXCFBColorKey() {
            this.b.order(ByteOrder.nativeOrder());
            this.data = this.b.asIntBuffer();
        }

        @Override
        public int sizeof() {
            return 8;
        }

        void setEnable(int enable) {
            this.data.put(0, enable);
        }

        void setColorKey(int key) {
            this.data.put(1, key);
        }
    }
}

