/*
 * Decompiled with CFR 0.152.
 */
package com.sun.glass.ui.monocle.x11;

import com.sun.glass.ui.monocle.AcceleratedScreen;
import com.sun.glass.ui.monocle.GLException;
import com.sun.glass.ui.monocle.NativeCursor;
import com.sun.glass.ui.monocle.NativePlatform;
import com.sun.glass.ui.monocle.NativeScreen;
import com.sun.glass.ui.monocle.NullCursor;
import com.sun.glass.ui.monocle.input.InputDeviceRegistry;
import com.sun.glass.ui.monocle.linux.LinuxInputDeviceRegistry;
import com.sun.glass.ui.monocle.linux.LinuxSystem;
import com.sun.glass.ui.monocle.x11.X11AcceleratedScreen;
import com.sun.glass.ui.monocle.x11.X11InputDeviceRegistry;
import com.sun.glass.ui.monocle.x11.X11Screen;
import java.security.AccessController;

public class X11Platform
extends NativePlatform {
    private final boolean x11InputAndCursor;

    public X11Platform() {
        LinuxSystem.getLinuxSystem().loadLibrary();
        this.x11InputAndCursor = AccessController.doPrivileged(() -> Boolean.getBoolean("x11.input"));
    }

    @Override
    protected InputDeviceRegistry createInputDeviceRegistry() {
        if (this.x11InputAndCursor) {
            return new X11InputDeviceRegistry();
        }
        return new LinuxInputDeviceRegistry(false);
    }

    @Override
    protected NativeCursor createCursor() {
        return new NullCursor();
    }

    @Override
    protected NativeScreen createScreen() {
        return new X11Screen(this.x11InputAndCursor);
    }

    @Override
    public synchronized AcceleratedScreen getAcceleratedScreen(int[] attributes) throws GLException {
        if (this.accScreen == null) {
            this.accScreen = new X11AcceleratedScreen(attributes);
        }
        return this.accScreen;
    }
}

