/*
 * Decompiled with CFR 0.152.
 */
package org.thethingsnetwork.data.mqtt;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.eclipse.paho.client.mqttv3.IMqttDeliveryToken;
import org.eclipse.paho.client.mqttv3.MqttCallback;
import org.eclipse.paho.client.mqttv3.MqttClient;
import org.eclipse.paho.client.mqttv3.MqttClientPersistence;
import org.eclipse.paho.client.mqttv3.MqttConnectOptions;
import org.eclipse.paho.client.mqttv3.MqttException;
import org.eclipse.paho.client.mqttv3.MqttMessage;
import org.eclipse.paho.client.mqttv3.persist.MemoryPersistence;
import org.thethingsnetwork.data.common.AbstractClient;
import org.thethingsnetwork.data.common.Connection;
import org.thethingsnetwork.data.common.Subscribable;
import org.thethingsnetwork.data.common.TriConsumer;
import org.thethingsnetwork.data.common.events.AbstractEventHandler;
import org.thethingsnetwork.data.common.events.ActivationHandler;
import org.thethingsnetwork.data.common.events.ConnectHandler;
import org.thethingsnetwork.data.common.events.ErrorHandler;
import org.thethingsnetwork.data.common.events.EventHandler;
import org.thethingsnetwork.data.common.events.UplinkHandler;
import org.thethingsnetwork.data.common.messages.ActivationMessage;
import org.thethingsnetwork.data.common.messages.DataMessage;
import org.thethingsnetwork.data.common.messages.DownlinkMessage;
import org.thethingsnetwork.data.common.messages.RawMessage;
import org.thethingsnetwork.data.common.messages.UplinkMessage;

public class Client
extends AbstractClient {
    private final String broker;
    private final String appId;
    private MqttClientPersistence persistence = new MemoryPersistence();
    private final MqttConnectOptions connOpts;
    private final ExecutorService executor = Executors.newCachedThreadPool();
    private final Map<Class, List<EventHandler>> handlers = new HashMap<Class, List<EventHandler>>();
    private MqttClient mqttClient;

    public Client(String _broker, String _appId, String _appAccessKey) throws URISyntaxException {
        this(_broker, _appId, _appAccessKey, null);
    }

    public Client(String _broker, String _appId, String _appAccessKey, MqttConnectOptions _connOpts) throws URISyntaxException {
        this.broker = this.validateBroker(_broker);
        this.appId = _appId;
        this.connOpts = _connOpts != null ? _connOpts : new MqttConnectOptions();
        this.connOpts.setUserName(_appId);
        this.connOpts.setPassword(_appAccessKey.toCharArray());
    }

    private String validateBroker(String _source) throws URISyntaxException {
        URI tempBroker = new URI(_source.contains(".") ? _source : _source + ".thethings.network");
        if ("tcp".equals(tempBroker.getScheme())) {
            if (tempBroker.getPort() == -1) {
                return tempBroker.toString() + ":1883";
            }
            return tempBroker.toString();
        }
        if ("ssl".equals(tempBroker.getScheme())) {
            if (tempBroker.getPort() == -1) {
                return tempBroker.toString() + ":8883";
            }
            return tempBroker.toString();
        }
        if (tempBroker.getPort() != -1) {
            return "tcp://" + tempBroker.toString();
        }
        return "tcp://" + tempBroker.toString() + ":1883";
    }

    public Client setMqttPersistence(MqttClientPersistence _persistence) {
        if (this.mqttClient != null) {
            throw new RuntimeException("Can not be called while client is running");
        }
        this.persistence = _persistence;
        return this;
    }

    public Client start() throws MqttException, Exception {
        if (this.mqttClient != null) {
            throw new RuntimeException("Already connected");
        }
        this.mqttClient = new MqttClient(this.broker, MqttClient.generateClientId(), this.persistence);
        this.mqttClient.connect(this.connOpts);
        this.mqttClient.setCallback(new MqttCallback(){

            public void connectionLost(Throwable cause) {
                Client.this.mqttClient = null;
                if (Client.this.handlers.containsKey(ErrorHandler.class)) {
                    ((List)Client.this.handlers.get(ErrorHandler.class)).stream().forEach(handler -> Client.this.executor.submit(() -> ((ErrorHandler)handler).safelyHandle(cause)));
                }
            }

            public void messageArrived(String topic, final MqttMessage message) throws Exception {
                String[] tokens = topic.split("\\/");
                if (tokens.length < 4) {
                    return;
                }
                block4 : switch (tokens[3]) {
                    case "up": {
                        if (!Client.this.handlers.containsKey(UplinkHandler.class)) break;
                        String field = tokens.length > 4 ? Client.this.concat(4, tokens) : null;
                        ((List)Client.this.handlers.get(UplinkHandler.class)).stream().forEach(handler -> Client.this.executor.submit(() -> {
                            block5: {
                                try {
                                    UplinkHandler uh = (UplinkHandler)handler;
                                    if (uh.matches(tokens[2], field)) {
                                        if (uh.isField()) {
                                            uh.handle(tokens[2], (DataMessage)new RawMessage(){
                                                String str;
                                                {
                                                    this.str = new String(message.getPayload());
                                                }

                                                public String asString() {
                                                    return this.str;
                                                }
                                            });
                                        } else {
                                            uh.handle(tokens[2], (DataMessage)AbstractClient.MAPPER.readValue(message.getPayload(), UplinkMessage.class));
                                        }
                                    }
                                }
                                catch (Exception ex) {
                                    if (!Client.this.handlers.containsKey(ErrorHandler.class)) break block5;
                                    ((List)Client.this.handlers.get(ErrorHandler.class)).stream().forEach(handler1 -> Client.this.executor.submit(() -> ((ErrorHandler)handler1).safelyHandle((Throwable)ex)));
                                }
                            }
                        }));
                        break;
                    }
                    case "events": {
                        if (tokens.length <= 5) break;
                        switch (tokens[4]) {
                            case "activations": {
                                if (!Client.this.handlers.containsKey(ActivationHandler.class)) break block4;
                                ((List)Client.this.handlers.get(ActivationHandler.class)).stream().forEach(handler -> Client.this.executor.submit(() -> {
                                    block3: {
                                        try {
                                            ActivationHandler ah = (ActivationHandler)handler;
                                            if (ah.matches(tokens[2])) {
                                                ah.handle(tokens[2], (ActivationMessage)AbstractClient.MAPPER.readValue(message.getPayload(), ActivationMessage.class));
                                            }
                                        }
                                        catch (Exception ex) {
                                            if (!Client.this.handlers.containsKey(ErrorHandler.class)) break block3;
                                            ((List)Client.this.handlers.get(ErrorHandler.class)).stream().forEach(handler1 -> Client.this.executor.submit(() -> ((ErrorHandler)handler1).safelyHandle((Throwable)ex)));
                                        }
                                    }
                                }));
                                break block4;
                            }
                        }
                        if (!Client.this.handlers.containsKey(AbstractEventHandler.class)) break;
                        ((List)Client.this.handlers.get(AbstractEventHandler.class)).stream().forEach(handler -> Client.this.executor.submit(() -> {
                            block3: {
                                try {
                                    AbstractEventHandler aeh = (AbstractEventHandler)handler;
                                    String event = Client.this.concat(4, tokens);
                                    if (aeh.matches(tokens[2], event)) {
                                        aeh.handle(tokens[2], event, new RawMessage(){
                                            String str;
                                            {
                                                this.str = new String(message.getPayload());
                                            }

                                            public String asString() {
                                                return this.str;
                                            }
                                        });
                                    }
                                }
                                catch (Exception ex) {
                                    if (!Client.this.handlers.containsKey(ErrorHandler.class)) break block3;
                                    ((List)Client.this.handlers.get(ErrorHandler.class)).stream().forEach(handler1 -> Client.this.executor.submit(() -> ((ErrorHandler)handler1).safelyHandle((Throwable)ex)));
                                }
                            }
                        }));
                    }
                }
            }

            public void deliveryComplete(IMqttDeliveryToken token) {
            }
        });
        for (List<EventHandler> ehl : this.handlers.values()) {
            for (EventHandler eh : ehl) {
                eh.subscribe(new Subscribable(){
                    private static final String WILDCARD_WORD = "+";
                    private static final String WILDCARD_PATH = "#";

                    public void subscribe(String[] _key) throws Exception {
                        StringJoiner sj = new StringJoiner("/");
                        for (String key : _key) {
                            sj.add(key);
                        }
                        Client.this.mqttClient.subscribe(sj.toString());
                    }

                    public String getWordWildcard() {
                        return WILDCARD_WORD;
                    }

                    public String getPathWildcard() {
                        return WILDCARD_PATH;
                    }
                });
            }
        }
        if (this.handlers.containsKey(ConnectHandler.class)) {
            this.handlers.get(ConnectHandler.class).stream().forEach(handler -> this.executor.submit(() -> {
                block2: {
                    try {
                        ((ConnectHandler)handler).handle(() -> this.mqttClient);
                    }
                    catch (Exception ex) {
                        if (!this.handlers.containsKey(ErrorHandler.class)) break block2;
                        this.handlers.get(ErrorHandler.class).stream().forEach(handler1 -> this.executor.submit(() -> ((ErrorHandler)handler1).safelyHandle((Throwable)ex)));
                    }
                }
            }));
        }
        return this;
    }

    private String concat(int _ignore, String[] _tokens) {
        StringJoiner sj = new StringJoiner("/");
        for (int i = _ignore; i < _tokens.length; ++i) {
            sj.add(_tokens[i]);
        }
        return sj.toString();
    }

    public Client end() throws MqttException, InterruptedException {
        if (this.mqttClient == null) {
            throw new RuntimeException("Not connected");
        }
        return this.end(5000L);
    }

    public Client end(long _timeout) throws MqttException, InterruptedException {
        if (this.mqttClient == null) {
            throw new RuntimeException("Not connected");
        }
        this.executor.awaitTermination(_timeout, TimeUnit.MILLISECONDS);
        this.mqttClient.disconnect(_timeout);
        if (!this.mqttClient.isConnected()) {
            this.mqttClient = null;
        }
        return this;
    }

    public Client endNow() throws MqttException {
        if (this.mqttClient == null) {
            throw new RuntimeException("Not connected");
        }
        this.mqttClient.disconnectForcibly(0L, 0L);
        this.mqttClient = null;
        return this;
    }

    public void send(String _devId, DownlinkMessage _payload) throws Exception {
        this.mqttClient.publish(this.appId + "/devices/" + _devId + "/down", MAPPER.writeValueAsBytes((Object)_payload), 0, false);
    }

    public Client onConnected(final Consumer<Connection> _handler) {
        if (this.mqttClient != null) {
            throw new RuntimeException("Already connected");
        }
        if (!this.handlers.containsKey(ConnectHandler.class)) {
            this.handlers.put(ConnectHandler.class, new LinkedList());
        }
        this.handlers.get(ConnectHandler.class).add((EventHandler)new ConnectHandler(){

            public void handle(Connection _client) {
                _handler.accept(_client);
            }
        });
        return this;
    }

    public Client onError(final Consumer<Throwable> _handler) {
        if (this.mqttClient != null) {
            throw new RuntimeException("Already connected");
        }
        if (!this.handlers.containsKey(ErrorHandler.class)) {
            this.handlers.put(ErrorHandler.class, new LinkedList());
        }
        this.handlers.get(ErrorHandler.class).add((EventHandler)new ErrorHandler(){

            public void handle(Throwable _error) {
                _handler.accept(_error);
            }
        });
        return this;
    }

    public Client onMessage(final String _devId, final String _field, final BiConsumer<String, DataMessage> _handler) {
        if (this.mqttClient != null) {
            throw new RuntimeException("Already connected");
        }
        if (!this.handlers.containsKey(UplinkHandler.class)) {
            this.handlers.put(UplinkHandler.class, new LinkedList());
        }
        this.handlers.get(UplinkHandler.class).add((EventHandler)new UplinkHandler(){

            public void handle(String _devId2, DataMessage _data) {
                _handler.accept(_devId2, _data);
            }

            public String getDevId() {
                return _devId;
            }

            public String getField() {
                return _field;
            }
        });
        return this;
    }

    public Client onMessage(String _devId, BiConsumer<String, DataMessage> _handler) {
        return this.onMessage(_devId, (String)null, (BiConsumer)_handler);
    }

    public Client onMessage(BiConsumer<String, DataMessage> _handler) {
        return this.onMessage((String)null, (String)null, (BiConsumer)_handler);
    }

    public Client onActivation(final String _devId, final BiConsumer<String, ActivationMessage> _handler) {
        if (this.mqttClient != null) {
            throw new RuntimeException("Already connected");
        }
        if (!this.handlers.containsKey(ActivationHandler.class)) {
            this.handlers.put(ActivationHandler.class, new LinkedList());
        }
        this.handlers.get(ActivationHandler.class).add((EventHandler)new ActivationHandler(){

            public void handle(String _devId2, ActivationMessage _data) {
                _handler.accept(_devId2, _data);
            }

            public String getDevId() {
                return _devId;
            }
        });
        return this;
    }

    public Client onActivation(BiConsumer<String, ActivationMessage> _handler) {
        return this.onActivation((String)null, (BiConsumer)_handler);
    }

    public Client onDevice(final String _devId, final String _event, final TriConsumer<String, String, RawMessage> _handler) {
        if (this.mqttClient != null) {
            throw new RuntimeException("Already connected");
        }
        if (!this.handlers.containsKey(AbstractEventHandler.class)) {
            this.handlers.put(AbstractEventHandler.class, new LinkedList());
        }
        this.handlers.get(AbstractEventHandler.class).add((EventHandler)new AbstractEventHandler(){

            public void handle(String _devId2, String _event2, RawMessage _data) {
                _handler.accept((Object)_devId2, (Object)_event2, (Object)_data);
            }

            public String getDevId() {
                return _devId;
            }

            public String getEvent() {
                return _event;
            }
        });
        return this;
    }

    public Client onDevice(String _devId, TriConsumer<String, String, RawMessage> _handler) {
        return this.onDevice(_devId, (String)null, (TriConsumer)_handler);
    }

    public Client onDevice(TriConsumer<String, String, RawMessage> _handler) {
        return this.onDevice((String)null, (String)null, (TriConsumer)_handler);
    }
}

