/*
 * Decompiled with CFR 0.152.
 */
package org.togglz.console.handlers;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.togglz.console.RequestEvent;
import org.togglz.console.RequestHandlerBase;
import org.togglz.console.shade.jmte.Engine;
import org.togglz.core.Feature;
import org.togglz.core.FeatureMetaData;
import org.togglz.core.context.FeatureContext;
import org.togglz.core.group.FeatureGroup;
import org.togglz.core.manager.FeatureManager;
import org.togglz.core.repository.FeatureState;
import org.togglz.core.util.Strings;

public class IndexPageHandler
extends RequestHandlerBase {
    @Override
    public boolean handles(String path) {
        return path.equals("/index");
    }

    @Override
    public void process(RequestEvent event) throws IOException {
        FeatureManager featureManager = FeatureContext.getFeatureManager();
        IndexPageTabView tabView = new IndexPageTabView();
        for (Feature feature : featureManager.getFeatures()) {
            FeatureState featureState = featureManager.getFeatureState(feature);
            tabView.add(feature, featureState);
        }
        HashMap<String, Object> model = new HashMap<String, Object>();
        model.put("tabView", tabView);
        String template = this.getResourceAsString("index.html");
        String content = new Engine().transform(template, model);
        this.writeResponse(event, content);
    }

    public static class IndexPageRow {
        private final String name;
        private final String label;
        private final boolean enabled;
        private final String users;

        public IndexPageRow(FeatureState state) {
            this.name = state.getFeature().name();
            this.label = FeatureMetaData.build((Feature)state.getFeature()).getLabel();
            this.enabled = state.isEnabled();
            this.users = Strings.join((Collection)state.getUsers(), (String)", ");
        }

        public String getName() {
            return this.name;
        }

        public String getLabel() {
            return this.label;
        }

        public boolean isEnabled() {
            return this.enabled;
        }

        public String getUsers() {
            return this.users;
        }
    }

    public static class IndexPageTab
    implements Comparable<IndexPageTab> {
        private final int index;
        private final List<IndexPageRow> rows = new ArrayList<IndexPageRow>();
        private final String label;

        private IndexPageTab(int index, String label) {
            this.index = index;
            this.label = label;
        }

        private static IndexPageTab allTab(int index) {
            return new IndexPageTab(index, null);
        }

        private static IndexPageTab groupTab(int index, String label) {
            return new IndexPageTab(index, label);
        }

        @Override
        public int compareTo(IndexPageTab o) {
            return (this.label != null ? this.label : "").compareTo(o.label != null ? o.label : "");
        }

        public void add(IndexPageRow row) {
            this.rows.add(row);
        }

        public List<IndexPageRow> getRows() {
            return this.rows;
        }

        public String getLabel() {
            return this.label;
        }

        public int getIndex() {
            return this.index;
        }

        public boolean isAllTab() {
            return this.index == 0;
        }
    }

    public static class IndexPageTabView {
        private final IndexPageTab allTab;
        private final Map<String, IndexPageTab> tabMap = new HashMap<String, IndexPageTab>();
        private final List<IndexPageTab> tabs = new ArrayList<IndexPageTab>();
        private int nextIndex = 0;

        public IndexPageTabView() {
            this.allTab = IndexPageTab.allTab(this.nextIndex++);
            this.tabs.add(this.allTab);
        }

        public void add(Feature feature, FeatureState featureState) {
            IndexPageRow row = new IndexPageRow(featureState);
            this.allTab.add(row);
            FeatureMetaData metaData = FeatureMetaData.build((Feature)feature);
            for (FeatureGroup group : metaData.getGroups()) {
                String label = group.getLabel();
                IndexPageTab tab = this.tabMap.get(label);
                if (tab == null) {
                    tab = IndexPageTab.groupTab(this.nextIndex++, label);
                    this.tabMap.put(label, tab);
                    this.tabs.add(tab);
                }
                tab.add(row);
            }
            Collections.sort(this.tabs);
        }

        public List<IndexPageTab> getTabs() {
            return this.tabs;
        }
    }
}

