/*
 * Decompiled with CFR 0.152.
 */
package org.togglz.console.handlers.edit;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.togglz.console.RequestEvent;
import org.togglz.console.RequestHandlerBase;
import org.togglz.console.model.FeatureModel;
import org.togglz.console.shade.jmte.Engine;
import org.togglz.core.Feature;
import org.togglz.core.manager.FeatureManager;
import org.togglz.core.metadata.FeatureMetaData;
import org.togglz.core.repository.FeatureState;
import org.togglz.core.util.Services;
import org.togglz.servlet.spi.CSRFToken;
import org.togglz.servlet.spi.CSRFTokenProvider;
import org.togglz.servlet.spi.CSRFTokenValidator;

public class EditPageHandler
extends RequestHandlerBase {
    @Override
    public boolean handles(String path) {
        return path.equals("/edit");
    }

    @Override
    public boolean adminOnly() {
        return true;
    }

    @Override
    public void process(RequestEvent event) throws IOException {
        FeatureState state;
        FeatureManager featureManager = event.getFeatureManager();
        HttpServletRequest request = event.getRequest();
        HttpServletResponse response = event.getResponse();
        if (!this.validateCSRFToken(event)) {
            this.renderErrorPage(event);
            return;
        }
        Feature feature = null;
        String featureAsString = request.getParameter("f");
        for (Feature f : featureManager.getFeatures()) {
            if (!f.name().equals(featureAsString)) continue;
            feature = f;
        }
        if (feature == null) {
            response.sendError(400);
            return;
        }
        FeatureMetaData metadata = featureManager.getMetaData(feature);
        List impls = featureManager.getActivationStrategies();
        FeatureModel featureModel = new FeatureModel(feature, metadata, impls);
        if ("GET".equals(request.getMethod())) {
            state = featureManager.getFeatureState(feature);
            featureModel.populateFromFeatureState(state);
            this.renderEditPage(event, featureModel);
        }
        if ("POST".equals(request.getMethod())) {
            featureModel.restoreFromRequest(request);
            if (featureModel.isValid()) {
                state = featureModel.toFeatureState();
                featureManager.setFeatureState(state);
                response.sendRedirect("index");
            } else {
                this.renderEditPage(event, featureModel);
            }
        }
    }

    private boolean validateCSRFToken(RequestEvent event) {
        boolean isValid = true;
        if (event.getRequestContext().isValidateCSRFToken()) {
            for (CSRFTokenValidator validator : Services.get(CSRFTokenValidator.class)) {
                if (validator.isTokenValid(event.getRequest())) continue;
                isValid = false;
                break;
            }
        }
        return isValid;
    }

    private void renderErrorPage(RequestEvent event) throws IOException {
        String template = this.getResourceAsString("error.html");
        String content = new Engine().transform(template, new HashMap<String, Object>());
        event.getResponse().setStatus(401);
        this.writeResponse(event, content);
    }

    private void renderEditPage(RequestEvent event, FeatureModel featureModel) throws IOException {
        ArrayList<CSRFToken> tokens = new ArrayList<CSRFToken>();
        for (CSRFTokenProvider provider : Services.get(CSRFTokenProvider.class)) {
            CSRFToken token = provider.getToken(event.getRequest());
            if (token == null) continue;
            tokens.add(token);
        }
        HashMap<String, Object> model = new HashMap<String, Object>();
        model.put("model", featureModel);
        model.put("tokens", tokens);
        String template = this.getResourceAsString("edit.html");
        String content = new Engine().transform(template, model);
        this.writeResponse(event, content);
    }
}

