/*
 * Decompiled with CFR 0.152.
 */
package org.togglz.console.shade.jmte.template;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.togglz.console.shade.jmte.DefaultModelAdaptor;
import org.togglz.console.shade.jmte.Engine;
import org.togglz.console.shade.jmte.ModelAdaptor;
import org.togglz.console.shade.jmte.ProcessListener;
import org.togglz.console.shade.jmte.ScopedMap;
import org.togglz.console.shade.jmte.TemplateContext;
import org.togglz.console.shade.jmte.message.ErrorEntry;
import org.togglz.console.shade.jmte.message.ErrorMessage;
import org.togglz.console.shade.jmte.message.JournalingErrorHandler;
import org.togglz.console.shade.jmte.template.AbstractTemplate;
import org.togglz.console.shade.jmte.template.VariableDescription;
import org.togglz.console.shade.jmte.token.ElseToken;
import org.togglz.console.shade.jmte.token.EndToken;
import org.togglz.console.shade.jmte.token.ExpressionToken;
import org.togglz.console.shade.jmte.token.ForEachToken;
import org.togglz.console.shade.jmte.token.IfToken;
import org.togglz.console.shade.jmte.token.InvalidToken;
import org.togglz.console.shade.jmte.token.PlainTextToken;
import org.togglz.console.shade.jmte.token.StringToken;
import org.togglz.console.shade.jmte.token.Token;
import org.togglz.console.shade.jmte.token.TokenStream;

public class InterpretedTemplate
extends AbstractTemplate {
    protected final TokenStream tokenStream;
    protected transient TemplateContext context;

    private static boolean isLocal(TemplateContext context, String variable) {
        for (Token token : context.scopes) {
            String foreachVarName;
            if (!(token instanceof ForEachToken) || !(foreachVarName = ((ForEachToken)token).getVarName()).equals(variable)) continue;
            return true;
        }
        return false;
    }

    public InterpretedTemplate(String template, String sourceName, Engine engine) {
        this.template = template;
        this.engine = engine;
        this.sourceName = sourceName;
        this.tokenStream = new TokenStream(sourceName, template, engine.getExprStartToken(), engine.getExprEndToken());
        this.tokenStream.prefill();
    }

    private StringBuilder getOutput() {
        return this.context.output;
    }

    @Override
    public synchronized Set<String> getUsedVariables() {
        if (this.usedVariables != null) {
            return this.usedVariables;
        }
        this.usedVariables = new TreeSet();
        List<VariableDescription> variableDescriptions = this.getUsedVariableDescriptions();
        for (VariableDescription variableDescription : variableDescriptions) {
            this.usedVariables.add(variableDescription.name);
        }
        return this.usedVariables;
    }

    @Override
    public List<ErrorEntry> getStaticErrors() {
        Engine engine = new Engine();
        JournalingErrorHandler errorHandler = new JournalingErrorHandler();
        engine.setErrorHandler(errorHandler);
        ScopedMap scopedMap = new ScopedMap(Collections.EMPTY_MAP);
        Locale locale = Locale.getDefault();
        this.context = new TemplateContext(this.template, locale, this.sourceName, scopedMap, new DefaultModelAdaptor(), engine, errorHandler, null);
        this.transformPure(this.context);
        ArrayList<ErrorEntry> staticErrors = new ArrayList<ErrorEntry>();
        for (ErrorEntry entry : errorHandler.entries) {
            if (!entry.errorMessage.isStatic) continue;
            staticErrors.add(entry);
        }
        return staticErrors;
    }

    @Override
    public List<VariableDescription> getUsedVariableDescriptions() {
        final ArrayList<VariableDescription> variableDescriptions = new ArrayList<VariableDescription>();
        Engine engine = new Engine();
        engine.setErrorHandler(new JournalingErrorHandler());
        ScopedMap scopedMap = new ScopedMap(Collections.EMPTY_MAP);
        ProcessListener processListener = new ProcessListener(){

            @Override
            public void log(TemplateContext context, Token token, ProcessListener.Action action) {
                if (token instanceof ExpressionToken) {
                    String name = ((ExpressionToken)token).getExpression();
                    String renderer = null;
                    String pattern = null;
                    VariableDescription.Context variableContext = null;
                    if (token instanceof StringToken) {
                        renderer = ((StringToken)token).getRendererName();
                        pattern = ((StringToken)token).getParameters();
                        variableContext = VariableDescription.Context.TEXT;
                    } else if (token instanceof IfToken) {
                        variableContext = VariableDescription.Context.IF;
                    } else if (token instanceof ForEachToken) {
                        variableContext = VariableDescription.Context.FOR_EACH;
                    }
                    if (!InterpretedTemplate.isLocal(context, name)) {
                        variableDescriptions.add(new VariableDescription(name, renderer, pattern, variableContext));
                    }
                }
            }
        };
        Locale locale = Locale.getDefault();
        this.context = new TemplateContext(this.template, locale, this.sourceName, scopedMap, new DefaultModelAdaptor(), engine, engine.getErrorHandler(), processListener);
        this.transformPure(this.context);
        return variableDescriptions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized String transform(Map<String, Object> model, Locale locale, ModelAdaptor modelAdaptor, ProcessListener processListener) {
        try {
            String transformed;
            this.context = new TemplateContext(this.template, locale, this.sourceName, new ScopedMap(model), modelAdaptor, this.engine, this.engine.getErrorHandler(), processListener);
            String string = transformed = this.transformPure(this.context);
            return string;
        }
        finally {
            this.context = null;
        }
    }

    protected String transformPure(TemplateContext context) {
        this.tokenStream.reset();
        this.tokenStream.nextToken();
        while (this.tokenStream.currentToken() != null) {
            this.content(false);
        }
        return this.getOutput().toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void foreach(boolean inheritedSkip) {
        ForEachToken feToken = (ForEachToken)this.tokenStream.currentToken();
        if (feToken.getVarName() == "_undefined") {
            this.context.engine.getErrorHandler().error(ErrorMessage.FOR_EACH_UNDEFINED_VARNAME, feToken);
            this.context.engine.getOutputAppender().append(this.getOutput(), "", feToken);
        }
        Iterable iterable = (Iterable)feToken.evaluate(this.context);
        feToken.setIterator(iterable.iterator());
        feToken.resetIndex();
        this.tokenStream.consume();
        this.context.model.enterScope();
        this.context.push(feToken);
        try {
            if (inheritedSkip || !feToken.iterator().hasNext()) {
                Token contentToken;
                while ((contentToken = this.tokenStream.currentToken()) != null && !(contentToken instanceof EndToken)) {
                    this.content(true);
                }
                if (contentToken == null) {
                    this.context.engine.getErrorHandler().error(ErrorMessage.MISSING_END, feToken);
                    this.context.engine.getOutputAppender().append(this.getOutput(), "", feToken);
                } else {
                    this.tokenStream.consume();
                    this.context.notifyProcessListener(contentToken, ProcessListener.Action.END);
                }
            } else {
                while (feToken.iterator().hasNext()) {
                    Token contentToken;
                    this.context.model.put(feToken.getVarName(), feToken.advance());
                    this.addSpecialVariables(feToken, this.context.model);
                    this.tokenStream.rewind(feToken);
                    while ((contentToken = this.tokenStream.currentToken()) != null && !(contentToken instanceof EndToken)) {
                        this.content(false);
                    }
                    if (contentToken == null) {
                        this.context.engine.getErrorHandler().error(ErrorMessage.MISSING_END, feToken);
                        this.context.engine.getOutputAppender().append(this.getOutput(), "", feToken);
                    } else {
                        this.tokenStream.consume();
                        this.context.notifyProcessListener(contentToken, ProcessListener.Action.END);
                    }
                    if (feToken.isLast()) continue;
                    this.context.engine.getOutputAppender().append(this.getOutput(), feToken.getSeparator(), feToken);
                }
            }
        }
        finally {
            this.context.model.exitScope();
            this.context.pop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void condition(boolean inheritedSkip) {
        IfToken ifToken = (IfToken)this.tokenStream.currentToken();
        this.tokenStream.consume();
        this.context.push(ifToken);
        try {
            Token contentToken;
            boolean localSkip;
            if (inheritedSkip) {
                localSkip = true;
            } else {
                boolean bl = localSkip = (Boolean)ifToken.evaluate(this.context) == false;
            }
            while ((contentToken = this.tokenStream.currentToken()) != null && !(contentToken instanceof EndToken) && !(contentToken instanceof ElseToken)) {
                this.content(localSkip);
            }
            if (contentToken instanceof ElseToken) {
                this.tokenStream.consume();
                if (!inheritedSkip) {
                    localSkip = !localSkip;
                }
                this.context.notifyProcessListener(contentToken, inheritedSkip ? ProcessListener.Action.SKIP : ProcessListener.Action.EVAL);
                while ((contentToken = this.tokenStream.currentToken()) != null && !(contentToken instanceof EndToken)) {
                    this.content(localSkip);
                }
            }
            if (contentToken == null) {
                this.context.engine.getErrorHandler().error(ErrorMessage.MISSING_END, ifToken);
                this.context.engine.getOutputAppender().append(this.getOutput(), null, ifToken);
            } else {
                this.tokenStream.consume();
                this.context.notifyProcessListener(contentToken, ProcessListener.Action.END);
            }
        }
        finally {
            this.context.pop();
        }
    }

    private void content(boolean skip) {
        Token token = this.tokenStream.currentToken();
        this.context.notifyProcessListener(token, skip ? ProcessListener.Action.SKIP : ProcessListener.Action.EVAL);
        if (token instanceof PlainTextToken) {
            this.tokenStream.consume();
            if (!skip) {
                this.context.engine.getOutputAppender().append(this.getOutput(), token.getText(), token);
            }
        } else if (token instanceof StringToken) {
            this.tokenStream.consume();
            if (!skip) {
                String expanded = (String)token.evaluate(this.context);
                this.context.engine.getOutputAppender().append(this.getOutput(), expanded, token);
            }
        } else if (token instanceof ForEachToken) {
            this.foreach(skip);
        } else if (token instanceof IfToken) {
            this.condition(skip);
        } else if (token instanceof ElseToken) {
            this.tokenStream.consume();
            this.context.engine.getErrorHandler().error(ErrorMessage.ELSE_OUT_OF_SCOPE, token);
            this.context.engine.getOutputAppender().append(this.getOutput(), "", token);
        } else if (token instanceof EndToken) {
            this.tokenStream.consume();
            this.context.engine.getErrorHandler().error(ErrorMessage.UNMATCHED_END, token);
            this.context.engine.getOutputAppender().append(this.getOutput(), "", token);
        } else if (token instanceof InvalidToken) {
            this.tokenStream.consume();
            this.context.engine.getErrorHandler().error(ErrorMessage.INVALID_EXPRESSION, token);
            this.context.engine.getOutputAppender().append(this.getOutput(), "", token);
        } else {
            this.tokenStream.consume();
            String evaluated = (String)token.evaluate(this.context);
            this.context.engine.getOutputAppender().append(this.getOutput(), evaluated, token);
        }
    }

    public String toString() {
        return this.template;
    }
}

