/*
 * Decompiled with CFR 0.152.
 */
package org.togglz.console.shade.jmte.token;

import java.util.ArrayList;
import java.util.List;
import org.togglz.console.shade.jmte.token.AbstractToken;
import org.togglz.console.shade.jmte.token.Lexer;
import org.togglz.console.shade.jmte.token.PlainTextToken;
import org.togglz.console.shade.jmte.token.Token;
import org.togglz.console.shade.jmte.util.StartEndPair;
import org.togglz.console.shade.jmte.util.Util;

public class TokenStream {
    private final Lexer lexer = new Lexer();
    private final String sourceName;
    private final String input;
    private final List<StartEndPair> scan;
    private final String splitStart;
    private final String splitEnd;
    private transient List<Token> tokens = null;
    private transient int currentTokenIndex = -1;
    private transient Token currentToken = null;

    public TokenStream(String sourceName, String input, String splitStart, String splitEnd) {
        this.sourceName = sourceName;
        this.input = input;
        this.splitStart = splitStart;
        this.splitEnd = splitEnd;
        this.scan = Util.scan(input, splitStart, splitEnd, true);
    }

    private void fillTokens() {
        this.tokens = new ArrayList<Token>();
        char[] inputChars = this.input.toCharArray();
        int offset = 0;
        int index = 0;
        for (StartEndPair startEndPair : this.scan) {
            AbstractToken token;
            int plainTextLengthBeforeNextToken = startEndPair.start - this.splitStart.length() - offset;
            if (plainTextLengthBeforeNextToken != 0) {
                token = new PlainTextToken(Util.NO_QUOTE_MINI_PARSER.unescape(new String(inputChars, offset, plainTextLengthBeforeNextToken)));
                token.setTokenIndex(index++);
                this.tokens.add(token);
            }
            offset = startEndPair.end + this.splitEnd.length();
            token = this.lexer.nextToken(inputChars, startEndPair.start, startEndPair.end);
            if (token == null) continue;
            token.setSourceName(this.sourceName);
            token.setTokenIndex(index++);
            this.tokens.add(token);
        }
        int remainingChars = this.input.length() - offset;
        if (remainingChars != 0) {
            PlainTextToken token = new PlainTextToken(Util.NO_QUOTE_MINI_PARSER.unescape(new String(inputChars, offset, remainingChars)));
            token.setTokenIndex(index++);
            this.tokens.add(token);
        }
    }

    private void initTokens() {
        if (this.tokens == null) {
            this.fillTokens();
            this.currentTokenIndex = 0;
        }
    }

    public Token nextToken() {
        this.initTokens();
        this.currentToken = this.currentTokenIndex < this.tokens.size() ? this.tokens.get(this.currentTokenIndex++) : null;
        return this.currentToken;
    }

    public void consume() {
        this.nextToken();
    }

    public Token currentToken() {
        return this.currentToken;
    }

    public void rewind(Token tokenToRewindTo) {
        this.initTokens();
        this.currentTokenIndex = tokenToRewindTo.getTokenIndex() + 1;
        this.consume();
    }

    public List<Token> getAllTokens() {
        this.initTokens();
        return this.tokens;
    }

    public void prefill() {
        this.initTokens();
    }

    public void reset() {
        this.currentTokenIndex = 0;
    }
}

