/*
 * Decompiled with CFR 0.152.
 */
package org.unitils.mock.report.impl;

import java.lang.reflect.Field;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.unitils.core.util.ObjectFormatter;
import org.unitils.mock.core.proxy.ProxyInvocation;
import org.unitils.util.ReflectionUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ProxyInvocationsReport {
    public static int OBJECT_FORMATTER_MAX_RECURSION_DEPT = 10;
    public static int MAX_INLINE_PARAMETER_LENGTH = 20;
    protected ObjectFormatter objectFormatter = new ObjectFormatter(OBJECT_FORMATTER_MAX_RECURSION_DEPT);
    protected Map<Object, String> testedObjectFieldValuesAndNames;

    public ProxyInvocationsReport(Object testedObject) {
        this.testedObjectFieldValuesAndNames = this.getFieldValuesAndNames(testedObject);
    }

    protected String formatInvokedAt(ProxyInvocation proxyInvocation) {
        return "  .....  at " + proxyInvocation.getInvokedAt();
    }

    protected String formatValue(Object valueAtInvocationTime, Object value, Class<?> type, List<FormattedObject> currentLargeObjects, Map<Object, FormattedObject> allLargeObjects, Map<Class<?>, Integer> largeObjectNameIndexes) {
        if (allLargeObjects.containsKey(valueAtInvocationTime)) {
            FormattedObject formattedObject = allLargeObjects.get(valueAtInvocationTime);
            currentLargeObjects.add(formattedObject);
            return formattedObject.getName();
        }
        String objectRepresentation = this.formatObject(valueAtInvocationTime);
        String valueName = this.testedObjectFieldValuesAndNames.get(value);
        if (valueName == null) {
            if (objectRepresentation.length() <= MAX_INLINE_PARAMETER_LENGTH) {
                return objectRepresentation;
            }
            valueName = this.createLargeValueName(type, largeObjectNameIndexes);
        }
        FormattedObject formattedObject = new FormattedObject(valueName, objectRepresentation);
        allLargeObjects.put(valueAtInvocationTime, formattedObject);
        currentLargeObjects.add(formattedObject);
        return valueName;
    }

    protected String createLargeValueName(Class<?> type, Map<Class<?>, Integer> largeObjectNameIndexes) {
        Integer index = largeObjectNameIndexes.get(type);
        if (index == null) {
            index = 0;
        }
        index = index + 1;
        largeObjectNameIndexes.put(type, index);
        String result = StringUtils.uncapitalize((String)type.getSimpleName());
        return result + index;
    }

    protected String formatInvocationIndex(int invocationIndex, int totalInvocationNumber) {
        int padSize = String.valueOf(totalInvocationNumber).length() + 2;
        return StringUtils.rightPad((String)(invocationIndex + "."), (int)padSize);
    }

    protected String formatObject(Object object) {
        return this.objectFormatter.format(object);
    }

    protected Map<Object, String> getFieldValuesAndNames(Object testedObject) {
        IdentityHashMap<Object, String> result = new IdentityHashMap<Object, String>();
        if (testedObject == null) {
            return result;
        }
        Set fields = ReflectionUtils.getAllFields(testedObject.getClass());
        for (Field field : fields) {
            Object value = ReflectionUtils.getFieldValue((Object)testedObject, (Field)field);
            if (value == null) continue;
            result.put(value, field.getName());
        }
        return result;
    }

    protected static class FormattedObject {
        private String name;
        private String representation;

        public FormattedObject(String name, String representation) {
            this.name = name;
            this.representation = representation;
        }

        public String getName() {
            return this.name;
        }

        public String getRepresentation() {
            return this.representation;
        }
    }
}

