/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.common.selector;

import java.lang.reflect.InvocationTargetException;
import java.security.PrivilegedAction;
import java.util.concurrent.atomic.AtomicReference;
import org.wildfly.common.Assert;
import org.wildfly.common.selector.DefaultSelector;
import org.wildfly.common.selector.SelectorPermission;

public abstract class Selector<T> {
    private static final Selector<?> NULL = new Selector<Object>(){

        @Override
        public Object get() {
            return null;
        }
    };
    private static final ClassValue<Holder<?>> selVal = new ClassValue<Holder<?>>(){

        @Override
        protected Holder<?> computeValue(Class<?> type) {
            return this.doCompute(type);
        }

        private <S> Holder<S> doCompute(Class<S> type) {
            Selector<?> selector = null;
            try {
                DefaultSelector defaultSelector = type.getAnnotation(DefaultSelector.class);
                if (defaultSelector != null) {
                    Class<Selector<?>> selectorType = defaultSelector.value();
                    selector = selectorType.getConstructor(new Class[0]).newInstance(new Object[0]);
                }
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException defaultSelector) {
                // empty catch block
            }
            Holder<S> holder = new Holder<S>(type);
            holder.set(selector);
            return holder;
        }
    };

    protected Selector() {
    }

    public abstract T get();

    public static <T> Selector<T> nullSelector() {
        return NULL;
    }

    public static <T> Selector<T> selectorFor(Class<T> clazz) {
        Selector sel;
        Assert.checkNotNullParam("clazz", clazz);
        Holder<?> holder = selVal.get(clazz);
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(holder.getGetPermission());
        }
        return (sel = (Selector)holder.get()) == null ? Selector.nullSelector() : sel;
    }

    public static <T> void setSelectorFor(Class<T> clazz, Selector<T> selector) {
        Assert.checkNotNullParam("clazz", clazz);
        Holder<?> holder = selVal.get(clazz);
        boolean set = false;
        boolean change = false;
        while (true) {
            SecurityManager sm;
            Selector oldValue;
            if ((oldValue = (Selector)holder.get()) == selector) {
                return;
            }
            if (oldValue == null) {
                if (!set) {
                    sm = System.getSecurityManager();
                    if (sm != null) {
                        sm.checkPermission(holder.getSetPermission());
                    }
                    set = true;
                }
                if (!holder.compareAndSet(null, selector)) continue;
                return;
            }
            if (!change) {
                sm = System.getSecurityManager();
                if (sm != null) {
                    sm.checkPermission(holder.getChangePermission());
                }
                change = true;
            }
            if (holder.compareAndSet(oldValue, selector)) break;
        }
    }

    public static <T> Getter<T> selectorGetterFor(Class<T> clazz) {
        Assert.checkNotNullParam("clazz", clazz);
        Holder<?> holder = selVal.get(clazz);
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(holder.getGetPermission());
        }
        return new Getter(holder);
    }

    public static <T> PrivilegedAction<Getter<T>> selectorGetterActionFor(final Class<T> clazz) {
        Assert.checkNotNullParam("clazz", clazz);
        return new PrivilegedAction<Getter<T>>(){

            @Override
            public Getter<T> run() {
                return Selector.selectorGetterFor(clazz);
            }
        };
    }

    public static SelectorPermission getGetPermissionFor(Class<?> clazz) {
        Assert.checkNotNullParam("clazz", clazz);
        return selVal.get(clazz).getGetPermission();
    }

    public static SelectorPermission getSetPermissionFor(Class<?> clazz) {
        Assert.checkNotNullParam("clazz", clazz);
        return selVal.get(clazz).getSetPermission();
    }

    public static SelectorPermission getChangePermissionFor(Class<?> clazz) {
        Assert.checkNotNullParam("clazz", clazz);
        return selVal.get(clazz).getChangePermission();
    }

    static final class Holder<T>
    extends AtomicReference<Selector<T>> {
        private final Class<T> clazz;
        private final SelectorPermission getPermission;
        private final SelectorPermission setPermission;
        private final SelectorPermission changePermission;
        private final AtomicReference<Object> lockRef = new AtomicReference();

        Holder(Class<T> clazz) {
            Assert.assertNotNull(clazz);
            this.clazz = clazz;
            this.getPermission = new SelectorPermission(clazz.getName(), "get");
            this.setPermission = new SelectorPermission(clazz.getName(), "set");
            this.changePermission = new SelectorPermission(clazz.getName(), "change");
        }

        Class<T> getClazz() {
            return this.clazz;
        }

        SelectorPermission getGetPermission() {
            return this.getPermission;
        }

        SelectorPermission getSetPermission() {
            return this.setPermission;
        }

        SelectorPermission getChangePermission() {
            return this.changePermission;
        }

        void lock(Object key) {
            Assert.assertNotNull(key);
            if (!this.lockRef.compareAndSet(null, key)) {
                throw new SecurityException("Selector is locked");
            }
        }

        void unlock(Object key) {
            Assert.assertNotNull(key);
            if (!this.lockRef.compareAndSet(key, null)) {
                throw new SecurityException("Selector could not be unlocked");
            }
        }
    }

    public static final class Getter<T> {
        private final Holder<T> holder;

        Getter(Holder<T> holder) {
            this.holder = holder;
        }

        public Selector<T> getSelector() {
            Selector sel = (Selector)this.holder.get();
            return sel == null ? Selector.nullSelector() : sel;
        }
    }
}

