/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.key;

import java.security.InvalidKeyException;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactorySpi;
import javax.crypto.spec.SecretKeySpec;
import org.jboss.logging.Logger;
import org.wildfly.security._private.ElytronMessages;

public final class RawSecretKeyFactory
extends SecretKeyFactorySpi {
    ElytronMessages log = (ElytronMessages)Logger.getMessageLogger(ElytronMessages.class, (String)"org.wildfly.security");

    @Override
    protected SecretKey engineGenerateSecret(KeySpec keySpec) throws InvalidKeySpecException {
        if (keySpec instanceof SecretKeySpec) {
            return (SecretKeySpec)keySpec;
        }
        throw this.log.keySpecMustBeSecretKeySpec(keySpec.getClass().getName());
    }

    @Override
    protected KeySpec engineGetKeySpec(SecretKey key, Class<?> keySpec) throws InvalidKeySpecException {
        if (SecretKeySpec.class.isAssignableFrom(keySpec) && key instanceof SecretKeySpec) {
            return (SecretKeySpec)key;
        }
        throw this.log.keyMustImplementSecretKeySpecAndKeySpecMustBeSecretKeySpec(key.getClass().getName() + ", " + keySpec.getName());
    }

    @Override
    protected SecretKey engineTranslateKey(SecretKey key) throws InvalidKeyException {
        return key;
    }
}

