/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.mechanism.scram;

import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.SecureRandom;
import java.util.Arrays;
import java.util.NoSuchElementException;
import java.util.Random;
import java.util.concurrent.ThreadLocalRandom;
import java.util.function.Supplier;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.sasl.AuthorizeCallback;
import org.wildfly.common.Assert;
import org.wildfly.common.bytes.ByteStringBuilder;
import org.wildfly.common.iteration.ByteIterator;
import org.wildfly.security.auth.callback.ChannelBindingCallback;
import org.wildfly.security.mechanism.AuthenticationMechanismException;
import org.wildfly.security.mechanism.ScramServerErrorCode;
import org.wildfly.security.mechanism.ScramServerException;
import org.wildfly.security.mechanism._private.ElytronMessages;
import org.wildfly.security.mechanism._private.MechanismUtil;
import org.wildfly.security.mechanism.scram.ScramFinalClientMessage;
import org.wildfly.security.mechanism.scram.ScramFinalServerMessage;
import org.wildfly.security.mechanism.scram.ScramInitialClientMessage;
import org.wildfly.security.mechanism.scram.ScramInitialServerMessage;
import org.wildfly.security.mechanism.scram.ScramInitialServerResult;
import org.wildfly.security.mechanism.scram.ScramMechanism;
import org.wildfly.security.mechanism.scram.ScramUtil;
import org.wildfly.security.password.interfaces.ScramDigestPassword;
import org.wildfly.security.password.spec.IteratedPasswordAlgorithmSpec;
import org.wildfly.security.sasl.util.StringPrep;

public final class ScramServer {
    private final Supplier<Provider[]> providers;
    private final ScramMechanism mechanism;
    private final CallbackHandler callbackHandler;
    private final SecureRandom random;
    private final byte[] bindingData;
    private final String bindingType;
    private final int minimumIterationCount;
    private final int maximumIterationCount;

    ScramServer(ScramMechanism mechanism, CallbackHandler callbackHandler, SecureRandom random, byte[] bindingData, String bindingType, int minimumIterationCount, int maximumIterationCount, Supplier<Provider[]> providers) {
        this.mechanism = mechanism;
        this.callbackHandler = callbackHandler;
        this.random = random;
        this.bindingData = bindingData;
        this.bindingType = bindingType;
        this.minimumIterationCount = minimumIterationCount;
        this.maximumIterationCount = maximumIterationCount;
        this.providers = providers;
    }

    public ScramInitialClientMessage parseInitialClientMessage(ChannelBindingCallback bindingCallback, byte[] bytes) throws AuthenticationMechanismException {
        byte[] response = (byte[])bytes.clone();
        ByteIterator bi = ByteIterator.ofBytes((byte[])response);
        try {
            String authorizationID;
            boolean binding;
            byte[] bindingData;
            String bindingType;
            char cbindFlag = (char)bi.next();
            if (bindingCallback != null) {
                bindingType = bindingCallback.getBindingType();
                bindingData = bindingCallback.getBindingData();
            } else {
                bindingType = null;
                bindingData = null;
            }
            if (cbindFlag == 'p') {
                if (!this.mechanism.isPlus()) {
                    throw new ScramServerException(ElytronMessages.saslScram.mechChannelBindingNotSupported(), ScramServerErrorCode.SERVER_DOES_NOT_SUPPORT_CHANNEL_BINDING);
                }
                if (bindingType == null || bindingData == null) {
                    throw new ScramServerException(ElytronMessages.saslScram.mechChannelBindingNotProvided(), ScramServerErrorCode.CHANNEL_BINDING_NOT_PROVIDED);
                }
                if (bi.next() != 61) {
                    throw ElytronMessages.saslScram.mechInvalidMessageReceived();
                }
                if (!bindingType.equals(bi.delimitedBy(new int[]{44}).asUtf8String().drainToString())) {
                    throw new ScramServerException(ElytronMessages.saslScram.mechChannelBindingTypeMismatch(), ScramServerErrorCode.UNSUPPORTED_CHANNEL_BINDING_TYPE);
                }
                binding = true;
            } else if (cbindFlag == 'y') {
                if (this.mechanism.isPlus()) {
                    throw new ScramServerException(ElytronMessages.saslScram.mechChannelBindingNotProvided(), ScramServerErrorCode.SERVER_DOES_SUPPORT_CHANNEL_BINDING);
                }
                if (bindingType != null || bindingData != null) {
                    throw new ScramServerException(ElytronMessages.saslScram.mechChannelBindingNotProvided(), ScramServerErrorCode.SERVER_DOES_SUPPORT_CHANNEL_BINDING);
                }
                binding = true;
            } else if (cbindFlag == 'n') {
                if (this.mechanism.isPlus()) {
                    throw new ScramServerException(ElytronMessages.saslScram.mechChannelBindingNotProvided(), ScramServerErrorCode.SERVER_DOES_SUPPORT_CHANNEL_BINDING);
                }
                if (bindingType != null || bindingData != null) {
                    throw new ScramServerException(ElytronMessages.saslScram.mechChannelBindingNotProvided(), ScramServerErrorCode.SERVER_DOES_SUPPORT_CHANNEL_BINDING);
                }
                binding = false;
            } else {
                throw ElytronMessages.saslScram.mechInvalidMessageReceived();
            }
            if (bi.next() != 44) {
                throw ElytronMessages.saslScram.mechInvalidMessageReceived();
            }
            int c = bi.next();
            if (c == 97) {
                if (bi.next() != 61) {
                    throw ElytronMessages.saslScram.mechInvalidClientMessage();
                }
                authorizationID = bi.delimitedBy(new int[]{44}).asUtf8String().drainToString();
                bi.next();
            } else if (c == 44) {
                authorizationID = null;
            } else {
                throw ElytronMessages.saslScram.mechInvalidClientMessage();
            }
            int initialPartIndex = (int)bi.getIndex();
            if (bi.next() == 110) {
                if (bi.next() != 61) {
                    throw ElytronMessages.saslScram.mechInvalidClientMessage();
                }
            } else {
                throw ElytronMessages.saslScram.mechInvalidClientMessage();
            }
            ByteStringBuilder bsb = new ByteStringBuilder();
            StringPrep.encode(bi.delimitedBy(new int[]{44}).asUtf8String().drainToString(), bsb, 0x10001FFFL);
            String authenticationName = new String(bsb.toArray(), StandardCharsets.UTF_8);
            bi.next();
            if (bi.next() != 114 || bi.next() != 61) {
                throw ElytronMessages.saslScram.mechInvalidClientMessage();
            }
            byte[] nonce = bi.delimitedBy(new int[]{44}).drain();
            if (bi.hasNext()) {
                throw ElytronMessages.saslScram.mechInvalidClientMessage();
            }
            return new ScramInitialClientMessage(this.mechanism, authorizationID, authenticationName, binding, bindingType, bindingData, nonce, initialPartIndex, response);
        }
        catch (NoSuchElementException ignored) {
            throw ElytronMessages.saslScram.mechInvalidMessageReceived();
        }
    }

    public ScramInitialServerResult evaluateInitialResponse(ScramInitialClientMessage clientMessage) throws AuthenticationMechanismException {
        boolean trace = ElytronMessages.saslScram.isTraceEnabled();
        if (clientMessage.getMechanism() != this.mechanism) {
            throw ElytronMessages.saslScram.mechUnmatchedMechanism(this.mechanism.toString(), clientMessage.getMechanism().toString());
        }
        NameCallback nameCallback = new NameCallback("Remote authentication name", clientMessage.getAuthenticationName());
        try {
            MechanismUtil.handleCallbacks(ElytronMessages.saslScram, this.callbackHandler, nameCallback);
        }
        catch (UnsupportedCallbackException e) {
            throw ElytronMessages.saslScram.mechCallbackHandlerDoesNotSupportUserName(e);
        }
        IteratedPasswordAlgorithmSpec generateParameters = new IteratedPasswordAlgorithmSpec(Math.max(this.minimumIterationCount, Math.min(this.maximumIterationCount, 20000)));
        ScramDigestPassword password = MechanismUtil.getPasswordCredential(clientMessage.getAuthenticationName(), this.callbackHandler, ScramDigestPassword.class, this.mechanism.getPasswordAlgorithm(), null, generateParameters, this.providers, ElytronMessages.saslScram);
        byte[] saltedPasswordBytes = password.getDigest();
        int iterationCount = password.getIterationCount();
        if (iterationCount < this.minimumIterationCount) {
            throw ElytronMessages.saslScram.mechIterationCountIsTooLow(iterationCount, this.minimumIterationCount);
        }
        if (iterationCount > this.maximumIterationCount) {
            throw ElytronMessages.saslScram.mechIterationCountIsTooHigh(iterationCount, this.maximumIterationCount);
        }
        byte[] salt = password.getSalt();
        if (trace) {
            ElytronMessages.saslScram.tracef("[S] Salt: %s%n", (Object)ByteIterator.ofBytes((byte[])salt).hexEncode().drainToString());
        }
        if (trace) {
            ElytronMessages.saslScram.tracef("[S] Salted password: %s%n", (Object)ByteIterator.ofBytes((byte[])saltedPasswordBytes).hexEncode().drainToString());
        }
        ByteStringBuilder b = new ByteStringBuilder();
        b.append('r').append('=');
        b.append(clientMessage.getRawNonce());
        byte[] serverNonce = ScramUtil.generateNonce(28, this.getRandom());
        b.append(serverNonce);
        b.append(',');
        b.append('s').append('=');
        b.appendLatin1(ByteIterator.ofBytes((byte[])salt).base64Encode());
        b.append(',');
        b.append('i').append('=');
        b.append(Integer.toString(iterationCount));
        byte[] messageBytes = b.toArray();
        return new ScramInitialServerResult(new ScramInitialServerMessage(clientMessage, serverNonce, salt, iterationCount, messageBytes), password);
    }

    public ScramFinalClientMessage parseFinalClientMessage(ScramInitialClientMessage initialResponse, ScramInitialServerResult initialResult, byte[] bytes) throws AuthenticationMechanismException {
        ScramInitialServerMessage initialChallenge = initialResult.getScramInitialChallenge();
        Assert.checkNotNullParam((String)"initialResponse", (Object)initialResponse);
        Assert.checkNotNullParam((String)"initialChallenge", (Object)initialChallenge);
        ScramMechanism mechanism = initialResponse.getMechanism();
        if (mechanism != initialChallenge.getMechanism()) {
            throw ElytronMessages.saslScram.mechUnmatchedMechanism(mechanism.toString(), initialChallenge.getMechanism().toString());
        }
        byte[] response = (byte[])bytes.clone();
        ByteIterator bi = ByteIterator.ofBytes((byte[])response);
        try {
            if (bi.next() != 99 || bi.next() != 61) {
                throw ElytronMessages.saslScram.mechInvalidMessageReceived();
            }
            ByteIterator ibi = bi.delimitedBy(new int[]{44}).asUtf8String().base64Decode();
            char cbindFlag = (char)ibi.next();
            String bindingType = initialResponse.getBindingType();
            byte[] bindingData = initialResponse.getRawBindingData();
            boolean binding = initialResponse.isBinding();
            if (cbindFlag == 'p') {
                if (!binding) {
                    throw new ScramServerException(ElytronMessages.saslScram.mechChannelBindingNotSupported(), ScramServerErrorCode.CHANNEL_BINDING_NOT_SUPPORTED);
                }
                if (bindingType == null || bindingData == null) {
                    throw new ScramServerException(ElytronMessages.saslScram.mechChannelBindingNotProvided(), ScramServerErrorCode.CHANNEL_BINDING_NOT_PROVIDED);
                }
                if (ibi.next() != 61) {
                    throw ElytronMessages.saslScram.mechInvalidMessageReceived();
                }
                if (!bindingType.equals(ibi.delimitedBy(new int[]{44}).asUtf8String().drainToString())) {
                    throw new ScramServerException(ElytronMessages.saslScram.mechChannelBindingTypeMismatch(), ScramServerErrorCode.UNSUPPORTED_CHANNEL_BINDING_TYPE);
                }
            } else if (cbindFlag == 'y') {
                if (mechanism.isPlus()) {
                    throw new ScramServerException(ElytronMessages.saslScram.mechChannelBindingNotProvided(), ScramServerErrorCode.SERVER_DOES_SUPPORT_CHANNEL_BINDING);
                }
                if (bindingType != null || bindingData != null) {
                    throw new ScramServerException(ElytronMessages.saslScram.mechChannelBindingNotProvided(), ScramServerErrorCode.SERVER_DOES_SUPPORT_CHANNEL_BINDING);
                }
            } else if (cbindFlag == 'n') {
                if (binding) {
                    throw new ScramServerException(ElytronMessages.saslScram.mechChannelBindingNotProvided(), ScramServerErrorCode.SERVER_DOES_SUPPORT_CHANNEL_BINDING);
                }
                if (mechanism.isPlus()) {
                    throw new ScramServerException(ElytronMessages.saslScram.mechChannelBindingNotProvided(), ScramServerErrorCode.SERVER_DOES_SUPPORT_CHANNEL_BINDING);
                }
            } else {
                throw ElytronMessages.saslScram.mechInvalidMessageReceived();
            }
            if (ibi.next() != 44) {
                throw ElytronMessages.saslScram.mechInvalidMessageReceived();
            }
            int c = ibi.next();
            if (c == 97) {
                if (ibi.next() != 61) {
                    throw ElytronMessages.saslScram.mechInvalidClientMessage();
                }
                String authorizationID = ibi.delimitedBy(new int[]{44}).asUtf8String().drainToString();
                ibi.next();
                if (!authorizationID.equals(initialResponse.getAuthorizationId())) {
                    throw ElytronMessages.saslScram.mechAuthorizationIdChanged();
                }
            } else if (c == 44) {
                if (initialResponse.getAuthorizationId() != null) {
                    throw ElytronMessages.saslScram.mechAuthorizationIdChanged();
                }
            } else {
                throw ElytronMessages.saslScram.mechInvalidClientMessage();
            }
            if (bindingData != null && !ibi.contentEquals(ByteIterator.ofBytes((byte[])bindingData))) {
                throw new ScramServerException(ElytronMessages.saslScram.mechChannelBindingChanged(), ScramServerErrorCode.CHANNEL_BINDINGS_DONT_MATCH);
            }
            bi.next();
            if (bi.next() != 114 || bi.next() != 61) {
                throw ElytronMessages.saslScram.mechInvalidClientMessage();
            }
            byte[] clientNonce = initialResponse.getRawNonce();
            byte[] serverNonce = initialChallenge.getRawServerNonce();
            if (!bi.delimitedBy(new int[]{44}).limitedTo(clientNonce.length).contentEquals(ByteIterator.ofBytes((byte[])clientNonce)) || !bi.delimitedBy(new int[]{44}).limitedTo(serverNonce.length).contentEquals(ByteIterator.ofBytes((byte[])serverNonce))) {
                throw ElytronMessages.saslScram.mechNoncesDoNotMatch();
            }
            int proofOffset = (int)bi.getIndex();
            bi.next();
            if (bi.next() != 112 || bi.next() != 61) {
                throw ElytronMessages.saslScram.mechInvalidClientMessage();
            }
            byte[] proof = bi.delimitedBy(new int[]{44}).asUtf8String().base64Decode().drain();
            if (bi.hasNext()) {
                throw ElytronMessages.saslScram.mechInvalidClientMessage();
            }
            return new ScramFinalClientMessage(initialResponse, initialChallenge, initialResult.getScramDigestPassword(), proof, response, proofOffset);
        }
        catch (NoSuchElementException ignored) {
            throw ElytronMessages.saslScram.mechInvalidMessageReceived();
        }
    }

    public ScramFinalServerMessage evaluateFinalClientMessage(ScramInitialServerResult initialResult, ScramFinalClientMessage clientMessage) throws AuthenticationMechanismException {
        boolean trace = ElytronMessages.saslScram.isTraceEnabled();
        if (clientMessage.getMechanism() != this.mechanism) {
            throw ElytronMessages.saslScram.mechUnmatchedMechanism(this.mechanism.toString(), clientMessage.getMechanism().toString());
        }
        ByteStringBuilder b = new ByteStringBuilder();
        try {
            Mac mac = Mac.getInstance(this.getMechanism().getHmacName());
            MessageDigest messageDigest = MessageDigest.getInstance(this.getMechanism().getMessageDigestName());
            mac.reset();
            byte[] saltedPassword = initialResult.getScramDigestPassword().getDigest();
            mac.init(new SecretKeySpec(saltedPassword, mac.getAlgorithm()));
            mac.update(ScramUtil.CLIENT_KEY_BYTES);
            byte[] clientKey = mac.doFinal();
            if (trace) {
                ElytronMessages.saslScram.tracef("[S] Client key: %s%n", (Object)ByteIterator.ofBytes((byte[])clientKey).hexEncode().drainToString());
            }
            messageDigest.reset();
            messageDigest.update(clientKey);
            byte[] storedKey = messageDigest.digest();
            if (trace) {
                ElytronMessages.saslScram.tracef("[S] Stored key: %s%n", (Object)ByteIterator.ofBytes((byte[])storedKey).hexEncode().drainToString());
            }
            mac.reset();
            mac.init(new SecretKeySpec(storedKey, mac.getAlgorithm()));
            byte[] clientFirstMessage = clientMessage.getInitialResponse().getRawMessageBytes();
            int clientFirstMessageBareStart = clientMessage.getInitialResponse().getInitialPartIndex();
            mac.update(clientFirstMessage, clientFirstMessageBareStart, clientFirstMessage.length - clientFirstMessageBareStart);
            if (trace) {
                ElytronMessages.saslScram.tracef("[S] Using client first message: %s%n", (Object)ByteIterator.ofBytes((byte[])Arrays.copyOfRange(clientFirstMessage, clientFirstMessageBareStart, clientFirstMessage.length)).hexEncode().drainToString());
            }
            mac.update((byte)44);
            byte[] serverFirstMessage = initialResult.getScramInitialChallenge().getRawMessageBytes();
            mac.update(serverFirstMessage);
            if (trace) {
                ElytronMessages.saslScram.tracef("[S] Using server first message: %s%n", (Object)ByteIterator.ofBytes((byte[])serverFirstMessage).hexEncode().drainToString());
            }
            mac.update((byte)44);
            byte[] response = clientMessage.getRawMessageBytes();
            int proofOffset = clientMessage.getProofOffset();
            mac.update(response, 0, proofOffset);
            if (trace) {
                ElytronMessages.saslScram.tracef("[S] Using client final message without proof: %s%n", (Object)ByteIterator.ofBytes((byte[])Arrays.copyOfRange(response, 0, proofOffset)).hexEncode().drainToString());
            }
            byte[] clientSignature = mac.doFinal();
            if (trace) {
                ElytronMessages.saslScram.tracef("[S] Client signature: %s%n", (Object)ByteIterator.ofBytes((byte[])clientSignature).hexEncode().drainToString());
            }
            mac.reset();
            mac.init(new SecretKeySpec(saltedPassword, mac.getAlgorithm()));
            mac.update(ScramUtil.SERVER_KEY_BYTES);
            byte[] serverKey = mac.doFinal();
            if (trace) {
                ElytronMessages.saslScram.tracef("[S] Server key: %s%n", (Object)ByteIterator.ofBytes((byte[])serverKey).hexEncode().drainToString());
            }
            mac.reset();
            mac.init(new SecretKeySpec(serverKey, mac.getAlgorithm()));
            mac.update(clientFirstMessage, clientFirstMessageBareStart, clientFirstMessage.length - clientFirstMessageBareStart);
            mac.update((byte)44);
            mac.update(serverFirstMessage);
            mac.update((byte)44);
            mac.update(response, 0, proofOffset);
            byte[] serverSignature = mac.doFinal();
            if (trace) {
                ElytronMessages.saslScram.tracef("[S] Server signature: %s%n", (Object)ByteIterator.ofBytes((byte[])serverSignature).hexEncode().drainToString());
            }
            byte[] recoveredClientProof = clientMessage.getRawClientProof();
            if (trace) {
                ElytronMessages.saslScram.tracef("[S] Client proof: %s%n", (Object)ByteIterator.ofBytes((byte[])recoveredClientProof).hexEncode().drainToString());
            }
            byte[] recoveredClientKey = (byte[])clientSignature.clone();
            ScramUtil.xor(recoveredClientKey, recoveredClientProof);
            if (trace) {
                ElytronMessages.saslScram.tracef("[S] Recovered client key: %s%n", (Object)ByteIterator.ofBytes((byte[])recoveredClientKey).hexEncode().drainToString());
            }
            if (!Arrays.equals(recoveredClientKey, clientKey)) {
                throw ElytronMessages.saslScram.mechAuthenticationRejectedInvalidProof();
            }
            String userName = clientMessage.getInitialResponse().getAuthenticationName();
            String authorizationID = clientMessage.getInitialResponse().getAuthorizationId();
            if (authorizationID == null || authorizationID.isEmpty()) {
                authorizationID = userName;
            } else {
                ByteStringBuilder bsb = new ByteStringBuilder();
                StringPrep.encode(authorizationID, bsb, 0x10001FFFL);
                authorizationID = new String(bsb.toArray(), StandardCharsets.UTF_8);
            }
            AuthorizeCallback authorizeCallback = new AuthorizeCallback(userName, authorizationID);
            try {
                MechanismUtil.handleCallbacks(ElytronMessages.saslScram, this.callbackHandler, authorizeCallback);
            }
            catch (UnsupportedCallbackException e) {
                throw ElytronMessages.saslScram.mechAuthorizationUnsupported(e);
            }
            if (!authorizeCallback.isAuthorized()) {
                throw ElytronMessages.saslScram.mechAuthorizationFailed(userName, authorizationID);
            }
            b.setLength(0);
            b.append('v').append('=');
            b.appendUtf8(ByteIterator.ofBytes((byte[])serverSignature).base64Encode());
            return new ScramFinalServerMessage(serverSignature, b.toArray());
        }
        catch (InvalidKeyException | NoSuchAlgorithmException e) {
            throw ElytronMessages.saslScram.mechMacAlgorithmNotSupported(e);
        }
    }

    public ScramMechanism getMechanism() {
        return this.mechanism;
    }

    public CallbackHandler getCallbackHandler() {
        return this.callbackHandler;
    }

    Random getRandom() {
        return this.random != null ? this.random : ThreadLocalRandom.current();
    }

    public byte[] getBindingData() {
        return this.bindingData == null ? null : (byte[])this.bindingData.clone();
    }

    byte[] getRawBindingData() {
        return this.bindingData;
    }

    public String getBindingType() {
        return this.bindingType;
    }
}

