/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.x500.cert;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.wildfly.common.iteration.CodePointIterator;
import org.wildfly.security.x500.GeneralName;
import org.wildfly.security.x500.cert.AccessDescription;
import org.wildfly.security.x500.cert.AuthorityInformationAccessExtension;
import org.wildfly.security.x500.cert.BasicConstraintsExtension;
import org.wildfly.security.x500.cert.ElytronMessages;
import org.wildfly.security.x500.cert.ExtendedKeyUsageExtension;
import org.wildfly.security.x500.cert.IssuerAlternativeNamesExtension;
import org.wildfly.security.x500.cert.KeyUsage;
import org.wildfly.security.x500.cert.KeyUsageExtension;
import org.wildfly.security.x500.cert.SubjectAlternativeNamesExtension;
import org.wildfly.security.x500.cert.SubjectInformationAccessExtension;
import org.wildfly.security.x500.cert.X509CertificateExtension;

class CertUtil {
    private static final String BASIC_CONSTRAINTS = "BasicConstraints";
    private static final String KEY_USAGE = "KeyUsage";
    private static final String CE_EXT_KEY_USAGE = "ExtendedKeyUsage";
    private static final String CE_SUBJECT_ALT_NAME = "SubjectAlternativeName";
    private static final String CE_ISSUER_ALT_NAME = "IssuerAlternativeName";
    private static final String PE_AUTHORITY_INFO_ACCESS = "AuthorityInfoAccess";
    private static final String PE_SUBJECT_INFO_ACCESS = "SubjectInfoAccess";
    private static final String CA = "ca";
    private static final String PATH_LEN = "pathlen";
    private static final String KP_SERVER_AUTH = "serverAuth";
    private static final String KP_CLIENT_AUTH = "clientAuth";
    private static final String KP_CODE_SIGNING = "codeSigning";
    private static final String KP_EMAIL_PROTECTION = "emailProtection";
    private static final String KP_TIME_STAMPING = "timeStamping";
    private static final String KP_OCSP_SIGNING = "OCSPSigning";
    private static final String AD_OCSP = "ocsp";
    private static final String AD_CA_ISSUERS = "caIssuers";
    private static final String AD_TIME_STAMPING = "timeStamping";
    private static final String AD_CA_REPOSITORY = "caRepository";
    private static final String EMAIL = "EMAIL";
    private static final String URI = "URI";
    private static final String DNS = "DNS";
    private static final String IP = "IP";
    private static final String OID = "OID";
    private static final String[] ALT_NAMES_TYPES = new String[]{"EMAIL", "URI", "DNS", "IP", "OID"};
    private static final int[] DELIMS = new int[]{44, 32};

    CertUtil() {
    }

    public static X509CertificateExtension getX509CertificateExtension(boolean critical, String extensionName, String extensionValue) throws IllegalArgumentException {
        X509CertificateExtension extension;
        block17: {
            try {
                if (extensionName.equalsIgnoreCase(BASIC_CONSTRAINTS)) {
                    CodePointIterator cpi = CodePointIterator.ofString((String)extensionValue);
                    CodePointIterator di = cpi.delimitedBy(DELIMS);
                    boolean ca = Boolean.parseBoolean(CertUtil.getKeyValue(CA, di.drainToString()));
                    CertUtil.skipDelims(di, cpi, DELIMS);
                    int pathLen = -1;
                    if (di.hasNext()) {
                        pathLen = Integer.parseInt(CertUtil.getKeyValue(PATH_LEN, di.drainToString()));
                    }
                    extension = new BasicConstraintsExtension(critical, ca, pathLen);
                    break block17;
                }
                if (extensionName.equalsIgnoreCase(KEY_USAGE)) {
                    CodePointIterator cpi = CodePointIterator.ofString((String)extensionValue);
                    CodePointIterator di = cpi.delimitedBy(DELIMS);
                    if (!di.hasNext()) {
                        throw ElytronMessages.log.invalidCertificateExtensionStringValue(extensionValue);
                    }
                    ArrayList<KeyUsage> keyUsages = new ArrayList<KeyUsage>();
                    while (di.hasNext()) {
                        KeyUsage keyUsage = KeyUsage.forName(di.drainToString());
                        if (keyUsage == null) {
                            throw ElytronMessages.log.invalidCertificateExtensionStringValue(extensionValue);
                        }
                        keyUsages.add(keyUsage);
                        CertUtil.skipDelims(di, cpi, DELIMS);
                    }
                    extension = new KeyUsageExtension(critical, keyUsages.toArray(new KeyUsage[keyUsages.size()]));
                    break block17;
                }
                if (extensionName.equalsIgnoreCase(CE_EXT_KEY_USAGE)) {
                    CodePointIterator cpi = CodePointIterator.ofString((String)extensionValue);
                    CodePointIterator di = cpi.delimitedBy(DELIMS);
                    if (!di.hasNext()) {
                        throw ElytronMessages.log.invalidCertificateExtensionStringValue(extensionValue);
                    }
                    ArrayList<String> keyPurposeIds = new ArrayList<String>();
                    while (di.hasNext()) {
                        String keyPurposeId = CertUtil.oidFromKeyPurpose(di.drainToString());
                        keyPurposeIds.add(keyPurposeId);
                        CertUtil.skipDelims(di, cpi, DELIMS);
                    }
                    extension = new ExtendedKeyUsageExtension(critical, keyPurposeIds);
                    break block17;
                }
                if (extensionName.equalsIgnoreCase(CE_SUBJECT_ALT_NAME)) {
                    extension = new SubjectAlternativeNamesExtension(critical, CertUtil.getGeneralNames(extensionValue));
                    break block17;
                }
                if (extensionName.equalsIgnoreCase(CE_ISSUER_ALT_NAME)) {
                    extension = new IssuerAlternativeNamesExtension(critical, CertUtil.getGeneralNames(extensionValue));
                    break block17;
                }
                if (extensionName.equalsIgnoreCase(PE_AUTHORITY_INFO_ACCESS)) {
                    if (critical) {
                        throw ElytronMessages.log.certificateExtensionMustBeNonCritical(extensionName);
                    }
                    extension = new AuthorityInformationAccessExtension(CertUtil.getAccessDescriptions(extensionValue));
                    break block17;
                }
                if (extensionName.equalsIgnoreCase(PE_SUBJECT_INFO_ACCESS)) {
                    if (critical) {
                        throw ElytronMessages.log.certificateExtensionMustBeNonCritical(extensionName);
                    }
                    extension = new SubjectInformationAccessExtension(CertUtil.getAccessDescriptions(extensionValue));
                    break block17;
                }
                throw ElytronMessages.log.certificateExtensionCreationFromStringNotSupported(extensionName);
            }
            catch (Exception e) {
                throw ElytronMessages.log.certificateExtensionCreationFromStringFailed(e);
            }
        }
        return extension;
    }

    private static void skipDelims(CodePointIterator di, CodePointIterator cpi, int ... delims) throws IllegalArgumentException {
        while (!di.hasNext() && cpi.hasNext()) {
            if (CertUtil.isDelim(cpi.next(), delims)) continue;
            throw ElytronMessages.log.invalidCertificateExtensionStringValue();
        }
    }

    private static boolean isDelim(int c, int ... delims) {
        for (int delim : delims) {
            if (delim != c) continue;
            return true;
        }
        return false;
    }

    private static String getKeyValue(String requiredKey, String keyAndValue) throws IllegalArgumentException {
        CodePointIterator cpi = CodePointIterator.ofString((String)keyAndValue);
        CodePointIterator di = cpi.delimitedBy(new int[]{58});
        if (!requiredKey.equalsIgnoreCase(di.drainToString())) {
            throw ElytronMessages.log.invalidCertificateExtensionStringValue(keyAndValue);
        }
        CertUtil.skipDelims(di, cpi, 58);
        return di.drainToString();
    }

    private static String oidFromKeyPurpose(String keyPurpose) {
        switch (keyPurpose) {
            case "serverAuth": {
                return "1.3.6.1.5.5.7.3.1";
            }
            case "clientAuth": {
                return "1.3.6.1.5.5.7.3.2";
            }
            case "codeSigning": {
                return "1.3.6.1.5.5.7.3.3";
            }
            case "emailProtection": {
                return "1.3.6.1.5.5.7.3.4";
            }
            case "timeStamping": {
                return "1.3.6.1.5.5.7.3.8";
            }
            case "OCSPSigning": {
                return "1.3.6.1.5.5.7.3.9";
            }
        }
        return keyPurpose;
    }

    private static List<GeneralName> getGeneralNames(String extensionValue) throws IllegalArgumentException {
        CodePointIterator cpi = CodePointIterator.ofString((String)extensionValue);
        CodePointIterator di = cpi.delimitedBy(DELIMS);
        if (!di.hasNext()) {
            throw ElytronMessages.log.invalidCertificateExtensionStringValue(extensionValue);
        }
        ArrayList<GeneralName> generalNames = new ArrayList<GeneralName>();
        while (di.hasNext()) {
            generalNames.add(CertUtil.getGeneralName(di.drainToString()));
            CertUtil.skipDelims(di, cpi, DELIMS);
        }
        return generalNames;
    }

    private static GeneralName getGeneralName(String typeAndValue) throws IllegalArgumentException {
        CodePointIterator cpi = CodePointIterator.ofString((String)typeAndValue);
        CodePointIterator di = cpi.delimitedBy(new int[]{58});
        String type = di.drainToString();
        for (String requiredType : ALT_NAMES_TYPES) {
            if (!requiredType.equalsIgnoreCase(type)) continue;
            CertUtil.skipDelims(di, cpi, 58);
            String value = cpi.drainToString();
            switch (type.toUpperCase(Locale.ENGLISH)) {
                case "EMAIL": {
                    return new GeneralName.RFC822Name(value);
                }
                case "URI": {
                    return new GeneralName.URIName(value);
                }
                case "DNS": {
                    return new GeneralName.DNSName(value);
                }
                case "IP": {
                    return new GeneralName.IPAddress(value);
                }
                case "OID": {
                    return new GeneralName.RegisteredID(value);
                }
            }
            throw ElytronMessages.log.invalidCertificateExtensionStringValue(typeAndValue);
        }
        throw ElytronMessages.log.invalidCertificateExtensionStringValue(typeAndValue);
    }

    private static List<AccessDescription> getAccessDescriptions(String extensionValue) throws IllegalArgumentException {
        CodePointIterator cpi = CodePointIterator.ofString((String)extensionValue);
        CodePointIterator di = cpi.delimitedBy(DELIMS);
        if (!di.hasNext()) {
            throw ElytronMessages.log.invalidCertificateExtensionStringValue(extensionValue);
        }
        ArrayList<AccessDescription> accessDescriptions = new ArrayList<AccessDescription>();
        while (di.hasNext()) {
            accessDescriptions.add(CertUtil.getAccessDescription(di.drainToString()));
            CertUtil.skipDelims(di, cpi, DELIMS);
        }
        return accessDescriptions;
    }

    private static AccessDescription getAccessDescription(String methodAndTypeAndValue) throws IllegalArgumentException {
        CodePointIterator cpi = CodePointIterator.ofString((String)methodAndTypeAndValue);
        CodePointIterator di = cpi.delimitedBy(new int[]{58});
        if (!di.hasNext()) {
            throw ElytronMessages.log.invalidCertificateExtensionStringValue(methodAndTypeAndValue);
        }
        String accessMethodId = CertUtil.oidFromMethod(di.drainToString());
        CertUtil.skipDelims(di, cpi, 58);
        String typeAndValue = cpi.drainToString();
        GeneralName accessLocation = CertUtil.getGeneralName(typeAndValue);
        return new AccessDescription(accessMethodId, accessLocation);
    }

    private static String oidFromMethod(String method) {
        switch (method) {
            case "ocsp": {
                return "1.3.6.1.5.5.7.48.1";
            }
            case "caIssuers": {
                return "1.3.6.1.5.5.7.48.2";
            }
            case "timeStamping": {
                return "1.3.6.1.5.5.7.48.3";
            }
            case "caRepository": {
                return "1.3.6.1.5.5.7.48.5";
            }
        }
        return method;
    }
}

