/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.sasl.digest._private;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidKeySpecException;
import java.util.Arrays;
import javax.crypto.Mac;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.DESKeySpec;
import javax.crypto.spec.DESedeKeySpec;
import javax.crypto.spec.SecretKeySpec;
import javax.security.sasl.SaslException;
import org.wildfly.common.bytes.ByteStringBuilder;
import org.wildfly.common.iteration.ByteIterator;
import org.wildfly.security.mechanism._private.ElytronMessages;

public final class DigestUtil {
    public static final String QOP_AUTH = "auth";
    public static final String QOP_AUTH_INT = "auth-int";
    public static final String QOP_AUTH_CONF = "auth-conf";
    public static final String[] QOP_VALUES = new String[]{"auth", "auth-int", "auth-conf"};
    public static final String AUTH_METHOD = "AUTHENTICATE";
    public static final String SECURITY_MARK = "00000000000000000000000000000000";
    public static final String HASH_algorithm = "MD5";
    public static final String HMAC_algorithm = "HmacMD5";

    public static String passwordAlgorithm(String digestAlgorithm) {
        switch (digestAlgorithm) {
            case "DIGEST-MD5": {
                return "digest-md5";
            }
            case "DIGEST-SHA": {
                return "digest-sha";
            }
            case "DIGEST-SHA-256": {
                return "digest-sha-256";
            }
            case "DIGEST-SHA-384": {
                return "digest-sha-384";
            }
            case "DIGEST-SHA-512": {
                return "digest-sha-512";
            }
            case "DIGEST-SHA-512-256": {
                return "digest-sha-512-256";
            }
        }
        return null;
    }

    public static String messageDigestAlgorithm(String digestAlgorithm) {
        switch (digestAlgorithm) {
            case "DIGEST-MD5": {
                return HASH_algorithm;
            }
            case "DIGEST-SHA": {
                return "SHA";
            }
            case "DIGEST-SHA-256": {
                return "SHA-256";
            }
            case "DIGEST-SHA-384": {
                return "SHA-384";
            }
            case "DIGEST-SHA-512": {
                return "SHA-512";
            }
            case "DIGEST-SHA-512-256": {
                return "SHA-512-256";
            }
        }
        return null;
    }

    public static byte[] H_A1(MessageDigest messageDigest, byte[] digest_urp, byte[] nonce, byte[] cnonce, String authzid, Charset responseCharset) {
        ByteStringBuilder A1 = new ByteStringBuilder();
        A1.append(digest_urp);
        A1.append(':');
        A1.append(nonce);
        A1.append(':');
        A1.append(cnonce);
        if (authzid != null) {
            A1.append(':');
            A1.append(authzid);
        }
        return messageDigest.digest(A1.toArray());
    }

    public static byte[] digestResponse(MessageDigest messageDigest, byte[] H_A1, byte[] nonce, int nonce_count, byte[] cnonce, String authzid, String qop, String digest_uri, boolean auth) {
        String qop_value = qop != null && !"".equals(qop) ? qop : QOP_AUTH;
        ByteStringBuilder A2 = new ByteStringBuilder();
        if (auth) {
            A2.append(AUTH_METHOD);
        }
        A2.append(':');
        A2.append(digest_uri);
        if (QOP_AUTH_CONF.equals(qop_value) || QOP_AUTH_INT.equals(qop_value)) {
            A2.append(':');
            A2.append(SECURITY_MARK);
        }
        byte[] digest_A2 = messageDigest.digest(A2.toArray());
        ByteStringBuilder KD = new ByteStringBuilder();
        KD.append(ByteIterator.ofBytes((byte[])H_A1).hexEncode().drainToString().getBytes(StandardCharsets.US_ASCII));
        KD.append(':');
        KD.append(nonce);
        KD.append(':');
        KD.append(DigestUtil.convertToHexBytesWithLeftPadding(nonce_count, 8));
        KD.append(':');
        KD.append(cnonce);
        KD.append(':');
        KD.append(qop_value);
        KD.append(':');
        KD.append(ByteIterator.ofBytes((byte[])digest_A2).hexEncode().drainToString().getBytes(StandardCharsets.US_ASCII));
        KD.updateDigest(messageDigest);
        return ByteIterator.ofBytes((byte[])messageDigest.digest()).hexEncode().drainToString().getBytes(StandardCharsets.US_ASCII);
    }

    public static byte[] convertToHexBytesWithLeftPadding(int input, int totalLength) {
        byte[] retValue = new byte[totalLength];
        Arrays.fill(retValue, (byte)48);
        byte[] hex = Integer.toString(input, 16).getBytes(StandardCharsets.UTF_8);
        if (hex.length > totalLength) {
            throw ElytronMessages.saslDigest.requiredNegativePadding(totalLength, hex.length);
        }
        int from = totalLength - hex.length;
        for (int i = 0; i < hex.length; ++i) {
            retValue[from + i] = hex[i];
        }
        return retValue;
    }

    public static byte[] computeHMAC(byte[] kc, int sequenceNumber, Mac mac, byte[] message, int offset, int len) throws SaslException {
        SecretKeySpec ks = new SecretKeySpec(kc, HMAC_algorithm);
        try {
            mac.init(ks);
        }
        catch (InvalidKeyException e) {
            throw ElytronMessages.saslDigest.mechInvalidKeyForDigestHMAC().toSaslException();
        }
        byte[] buffer = new byte[len + 4];
        DigestUtil.integerByteOrdered(sequenceNumber, buffer, 0, 4);
        System.arraycopy(message, offset, buffer, 4, len);
        byte[] macBuffer = new byte[10];
        System.arraycopy(mac.doFinal(buffer), 0, macBuffer, 0, 10);
        return macBuffer;
    }

    public static void integerByteOrdered(int num, byte[] buf, int offset, int len) {
        assert (len >= 1 && len <= 4);
        for (int i = len - 1; i >= 0; --i) {
            buf[offset + i] = (byte)(num & 0xFF);
            num >>>= 8;
        }
    }

    public static int decodeByteOrderedInteger(byte[] buf, int offset, int len) {
        assert (len >= 1 && len <= 4);
        int result = buf[offset];
        for (int i = 1; i < len; ++i) {
            result <<= 8;
            result |= buf[offset + i] & 0xFF;
        }
        return result;
    }

    static byte[] create3desSubKey(byte[] keyBits, int offset) {
        assert (keyBits.length >= offset + 7);
        byte[] subkey = new byte[]{DigestUtil.fixParityBit((byte)(keyBits[offset] & 0xFF)), DigestUtil.fixParityBit((byte)(keyBits[offset] << 7 | (keyBits[offset + 1] & 0xFF) >> 1)), DigestUtil.fixParityBit((byte)(keyBits[offset + 1] << 6 | (keyBits[offset + 2] & 0xFF) >> 2)), DigestUtil.fixParityBit((byte)(keyBits[offset + 2] << 5 | (keyBits[offset + 3] & 0xFF) >> 3)), DigestUtil.fixParityBit((byte)(keyBits[offset + 3] << 4 | (keyBits[offset + 4] & 0xFF) >> 4)), DigestUtil.fixParityBit((byte)(keyBits[offset + 4] << 3 | (keyBits[offset + 5] & 0xFF) >> 5)), DigestUtil.fixParityBit((byte)(keyBits[offset + 5] << 2 | (keyBits[offset + 6] & 0xFF) >> 6)), DigestUtil.fixParityBit((byte)(keyBits[offset + 6] << 1))};
        return subkey;
    }

    public static SecretKey createDesSecretKey(byte[] keyBits) throws NoSuchAlgorithmException, InvalidKeyException, InvalidKeySpecException {
        assert (keyBits.length >= 7);
        DESKeySpec spec = new DESKeySpec(DigestUtil.create3desSubKey(keyBits, 0), 0);
        SecretKeyFactory desFact = SecretKeyFactory.getInstance("DES");
        return desFact.generateSecret(spec);
    }

    public static SecretKey create3desSecretKey(byte[] keyBits) throws NoSuchAlgorithmException, InvalidKeyException, InvalidKeySpecException {
        assert (keyBits.length >= 14);
        byte[] key = new byte[24];
        System.arraycopy(DigestUtil.create3desSubKey(keyBits, 0), 0, key, 0, 8);
        System.arraycopy(DigestUtil.create3desSubKey(keyBits, 7), 0, key, 8, 8);
        System.arraycopy(key, 0, key, 16, 8);
        DESedeKeySpec spec = new DESedeKeySpec(key, 0);
        SecretKeyFactory desFact = SecretKeyFactory.getInstance("DESede");
        return desFact.generateSecret(spec);
    }

    private static byte fixParityBit(byte toFix) {
        return (Integer.bitCount(toFix & 0xFF) & 1) == 0 ? (byte)(toFix ^ 1) : toFix;
    }
}

